/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.blazemeter;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunRequestStats;
import us.abstracta.jmeter.javadsl.blazemeter.api.TestRunSummaryStats;
import us.abstracta.jmeter.javadsl.core.TestPlanStats;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;
import us.abstracta.jmeter.javadsl.core.stats.TimeMetricSummary;

public class BlazeMeterTestPlanStats
extends TestPlanStats {
    public BlazeMeterTestPlanStats(TestRunSummaryStats.TestRunLabeledSummary summary, List<TestRunRequestStats> labeledStats) {
        super(() -> null);
        for (TestRunRequestStats labeledStat : labeledStats) {
            BlazemeterStatsSummary labelStatsSummary = new BlazemeterStatsSummary(labeledStat, summary);
            if ("ALL".equals(labeledStat.getLabelName())) {
                this.overallStats = labelStatsSummary;
                this.setStart(labelStatsSummary.firstTime);
                this.setEnd(labelStatsSummary.endTime);
                continue;
            }
            this.labeledStats.put(labeledStat.getLabelName(), labelStatsSummary);
        }
    }

    private static class BlazeMeterTimeMetricSummary
    implements TimeMetricSummary {
        private final Duration min;
        private final Duration max;
        private final Duration mean;
        private final Duration median;
        private final Duration percentile90;
        private final Duration percentile95;
        private final Duration percentile99;

        private BlazeMeterTimeMetricSummary(long min, long max, double mean, double median, double percentile90, double percentile95, double percentile99) {
            this.min = Duration.ofMillis(min);
            this.max = Duration.ofMillis(max);
            this.mean = this.double2Duration(mean);
            this.median = this.double2Duration(median);
            this.percentile90 = this.double2Duration(percentile90);
            this.percentile95 = this.double2Duration(percentile95);
            this.percentile99 = this.double2Duration(percentile99);
        }

        private Duration double2Duration(double millis) {
            return Duration.ofMillis(Math.round(millis));
        }

        public Duration min() {
            return this.min;
        }

        public Duration max() {
            return this.max;
        }

        public Duration mean() {
            return this.mean;
        }

        public Duration median() {
            return this.median;
        }

        public Duration perc90() {
            return this.percentile90;
        }

        public Duration perc95() {
            return this.percentile95;
        }

        public Duration perc99() {
            return this.percentile99;
        }
    }

    private static class BlazemeterStatsSummary
    implements StatsSummary {
        private final Instant firstTime;
        private final Instant endTime;
        private final CountMetricSummary samples = new CountMetricSummary();
        private final CountMetricSummary errors = new CountMetricSummary();
        private final CountMetricSummary receivedBytes = new CountMetricSummary();
        private final BlazeMeterTimeMetricSummary sampleTime;

        private BlazemeterStatsSummary(TestRunRequestStats labeledStat, TestRunSummaryStats.TestRunLabeledSummary summary) {
            this.firstTime = summary.getFirst();
            this.endTime = summary.getLast();
            long elapsedTimeMillis = labeledStat.getDuration();
            this.samples.increment(labeledStat.getSamples(), elapsedTimeMillis);
            this.errors.increment(labeledStat.getErrorsCount(), elapsedTimeMillis);
            this.sampleTime = new BlazeMeterTimeMetricSummary(labeledStat.getMinResponseTime(), labeledStat.getMaxResponseTime(), labeledStat.getAvgResponseTime(), labeledStat.getMedianResponseTime(), labeledStat.getPerc90(), labeledStat.getPerc95(), labeledStat.getPerc99());
            this.receivedBytes.increment(Math.round(labeledStat.getAvgBytes() / 1000.0 * (double)elapsedTimeMillis), elapsedTimeMillis);
        }

        public void add(SampleResult result) {
        }

        public Instant firstTime() {
            return this.firstTime;
        }

        public Instant endTime() {
            return this.endTime;
        }

        public CountMetricSummary samples() {
            return this.samples;
        }

        public CountMetricSummary errors() {
            return this.errors;
        }

        public BlazeMeterTimeMetricSummary sampleTime() {
            return this.sampleTime;
        }

        public CountMetricSummary receivedBytes() {
            return this.receivedBytes;
        }

        public CountMetricSummary sentBytes() {
            throw new UnsupportedOperationException("BlazeMeter API does not provide an efficient way to get this value.");
        }
    }
}

