/*
 * Decompiled with CFR 0.152.
 */
package uk.uuid.slf4j.android;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import uk.uuid.slf4j.android.CategoryMap;
import uk.uuid.slf4j.android.LogLevel;
import uk.uuid.slf4j.android.LoggerConfig;

final class LoggingConfig {
    public static final String DEFAULT_FILENAME = "config.properties";
    private final CategoryMap map = new CategoryMap();

    LoggingConfig(String configFileName, Logger log) {
        long start = log.isTraceEnabled() ? System.nanoTime() : 0L;
        Properties props = new Properties();
        URL url = this.getClass().getResource(configFileName);
        if (url == null) {
            url = this.getClass().getResource("/eu/lp0/slf4j/android/" + configFileName);
        }
        if (url != null) {
            log.debug("Loading properties file from {}", (Object)url);
            try {
                props.load(url.openStream());
            }
            catch (IOException e) {
                log.error("Error loading properties file from {}", (Object)url, (Object)e);
                props.clear();
            }
        } else {
            log.debug("No config file");
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("tag")) {
                if (key.length() == 3) {
                    key = "";
                } else {
                    if (key.charAt(3) != '.') continue;
                    key = key.substring(4);
                }
                if (value.length() > 23) {
                    if (key.length() == 0) {
                        log.warn("Ignoring invalid default tag {}", (Object)value);
                        continue;
                    }
                    log.warn("Ignoring invalid tag {} for {}", (Object)value, (Object)key);
                    continue;
                }
                this.map.put(key, new LoggerConfig(value));
                continue;
            }
            if (key.startsWith("level")) {
                if (key.length() == 5) {
                    key = "";
                } else {
                    if (key.charAt(5) != '.') continue;
                    key = key.substring(6);
                }
                try {
                    this.map.put(key, new LoggerConfig(LogLevel.valueOf(value.toUpperCase(Locale.ENGLISH))));
                }
                catch (IllegalArgumentException e) {
                    if (key.length() == 0) {
                        log.warn("Ignoring invalid default log level {}", (Object)value);
                        continue;
                    }
                    log.warn("Ignoring invalid log level {} for {}", (Object)value, (Object)key);
                }
                continue;
            }
            if (key.startsWith("showName")) {
                if (key.length() == 8) {
                    key = "";
                } else {
                    if (key.charAt(8) != '.') continue;
                    key = key.substring(9);
                }
                try {
                    this.map.put(key, new LoggerConfig(LoggerConfig.ShowName.valueOf(value.toUpperCase(Locale.ENGLISH))));
                }
                catch (IllegalArgumentException e) {
                    if (key.length() == 0) {
                        log.warn("Ignoring invalid default show name setting {}", (Object)value);
                        continue;
                    }
                    log.warn("Ignoring invalid show name setting {} for {}", (Object)value, (Object)key);
                }
                continue;
            }
            if (!key.startsWith("showThread")) continue;
            if (key.length() == 10) {
                key = "";
            } else {
                if (key.charAt(10) != '.') continue;
                key = key.substring(11);
            }
            LoggerConfig config = new LoggerConfig();
            config.showThread = Boolean.valueOf(value);
            this.map.put(key, config);
        }
        if (log.isTraceEnabled()) {
            long stop = System.nanoTime();
            log.trace("Config processing completed in {}\u00b5s", (Object)TimeUnit.NANOSECONDS.toMicros(stop - start));
        }
    }

    final LoggerConfig get(String name) {
        return this.map.get(name);
    }
}

