/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CqlFileParser;
import uk.sky.cqlmigrate.CqlLoader;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.SessionContext;

class KeyspaceBootstrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyspaceBootstrapper.class);
    private final SessionContext sessionContext;
    private final String keyspace;
    private final CqlPaths paths;

    KeyspaceBootstrapper(SessionContext sessionContext, String keyspace, CqlPaths paths) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
        this.paths = paths;
    }

    void bootstrap() {
        Session session = this.sessionContext.getSession();
        KeyspaceMetadata keyspaceMetadata = session.getCluster().getMetadata().getKeyspace(this.keyspace);
        if (keyspaceMetadata == null) {
            this.paths.applyBootstrap((filename, path) -> {
                LOGGER.info("Keyspace not found, applying {} at consistency level {}", (Object)path, (Object)this.sessionContext.getWriteConsistencyLevel());
                List<String> cqlStatements = CqlFileParser.getCqlStatementsFrom(path);
                CqlLoader.load(this.sessionContext, cqlStatements);
                LOGGER.info("Applied: bootstrap.cql");
            });
        } else {
            LOGGER.info("Keyspace found, not applying bootstrap.cql");
        }
    }
}

