/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CassandraClusterFactory;
import uk.sky.cqlmigrate.CassandraLockConfig;
import uk.sky.cqlmigrate.CqlMigrator;
import uk.sky.cqlmigrate.CqlMigratorConfig;
import uk.sky.cqlmigrate.CqlMigratorFactory;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.KeyspaceBootstrapper;
import uk.sky.cqlmigrate.Lock;
import uk.sky.cqlmigrate.LockConfig;
import uk.sky.cqlmigrate.LockingMechanism;
import uk.sky.cqlmigrate.SchemaLoader;
import uk.sky.cqlmigrate.SchemaUpdates;
import uk.sky.cqlmigrate.SessionContext;
import uk.sky.cqlmigrate.SessionContextFactory;

final class CqlMigratorImpl
implements CqlMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CqlMigratorImpl.class);
    private final CqlMigratorConfig cqlMigratorConfig;
    private final SessionContextFactory sessionContextFactory;

    CqlMigratorImpl(CqlMigratorConfig cqlMigratorConfig, SessionContextFactory sessionContextFactory) {
        this.cqlMigratorConfig = cqlMigratorConfig;
        this.sessionContextFactory = sessionContextFactory;
    }

    public static void main(String[] args) {
        String hosts = System.getProperty("hosts");
        String keyspace = System.getProperty("keyspace");
        String directoriesProperty = System.getProperty("directories");
        String port = System.getProperty("port");
        String username = System.getProperty("username");
        String password = System.getProperty("password");
        Preconditions.checkNotNull((Object)hosts, (Object)"'hosts' property should be provided having value of a comma separated list of cassandra hosts");
        Preconditions.checkNotNull((Object)keyspace, (Object)"'keyspace' property should be provided having value of the cassandra keyspace");
        Preconditions.checkNotNull((Object)directoriesProperty, (Object)"'directories' property should be provided having value of the comma separated list of paths to cql files");
        Collection directories = Arrays.stream(directoriesProperty.split(",")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        CqlMigratorFactory.create(CassandraLockConfig.builder().build()).migrate(hosts.split(","), port == null ? 9042 : Integer.parseInt(port), username, password, keyspace, directories);
    }

    @Override
    public void migrate(String[] hosts, int port, String username, String password, String keyspace, Collection<Path> directories) {
        try (Cluster cluster = CassandraClusterFactory.createCluster(hosts, port, username, password);
             Session session = cluster.connect();){
            this.migrate(session, keyspace, directories);
        }
    }

    @Override
    public void migrate(Session session, String keyspace, Collection<Path> directories) {
        LockingMechanism lockingMechanism = this.cqlMigratorConfig.getCassandraLockConfig().getLockingMechanism(session, keyspace);
        LockConfig lockConfig = this.cqlMigratorConfig.getCassandraLockConfig();
        boolean migrationFailed = false;
        Lock lock = new Lock(lockingMechanism, lockConfig);
        lock.lock();
        try {
            LOGGER.info("Loading cql files from {}", directories);
            CqlPaths paths = CqlPaths.create(directories);
            SessionContext sessionContext = this.sessionContextFactory.getInstance(session, this.cqlMigratorConfig);
            KeyspaceBootstrapper keyspaceBootstrapper = new KeyspaceBootstrapper(sessionContext, keyspace, paths);
            SchemaUpdates schemaUpdates = new SchemaUpdates(sessionContext, keyspace);
            SchemaLoader schemaLoader = new SchemaLoader(sessionContext, keyspace, schemaUpdates, paths);
            keyspaceBootstrapper.bootstrap();
            schemaUpdates.initialise();
            schemaLoader.load();
        }
        catch (Exception e) {
            migrationFailed = true;
            throw e;
        }
        finally {
            lock.unlock(migrationFailed);
        }
    }

    @Override
    public void clean(String[] hosts, int port, String username, String password, String keyspace) {
        try (Cluster cluster = CassandraClusterFactory.createCluster(hosts, port, username, password);
             Session session = cluster.connect();){
            this.clean(session, keyspace);
        }
    }

    @Override
    public void clean(Session session, String keyspace) {
        Statement clean = new SimpleStatement("DROP KEYSPACE IF EXISTS " + keyspace).setConsistencyLevel(this.cqlMigratorConfig.getWriteConsistencyLevel());
        session.execute(clean);
        LOGGER.info("Cleaned {}", (Object)keyspace);
    }
}

