/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CqlFileParser;
import uk.sky.cqlmigrate.CqlLoader;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.SchemaChecker;
import uk.sky.cqlmigrate.SchemaUpdates;
import uk.sky.cqlmigrate.SessionContext;

class SchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);
    private final SessionContext sessionContext;
    private final String keyspace;
    private final SchemaUpdates schemaUpdates;
    private final SchemaChecker schemaChecker;
    private final CqlPaths paths;

    SchemaLoader(SessionContext sessionContext, String keyspace, SchemaUpdates schemaUpdates, SchemaChecker schemaChecker, CqlPaths paths) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
        this.schemaUpdates = schemaUpdates;
        this.schemaChecker = schemaChecker;
        this.paths = paths;
    }

    void load() {
        this.sessionContext.getSession().execute(SimpleStatement.newInstance((String)("USE " + this.keyspace + ";")).setConsistencyLevel(this.sessionContext.getReadConsistencyLevel()));
        this.paths.applyInSortedOrder(new Loader());
    }

    private class Loader
    implements CqlPaths.Function {
        private Loader() {
        }

        @Override
        public void apply(String filename, Path path) {
            if (SchemaLoader.this.schemaChecker.alreadyApplied(filename)) {
                if (SchemaLoader.this.schemaChecker.contentsAreDifferent(filename, path)) {
                    LOGGER.error("Contents have changed: {}", (Object)path.getFileName());
                    throw new IllegalStateException("Contents have changed for " + filename + " at " + path);
                }
                LOGGER.info("Skipped: {}", (Object)path.getFileName());
            } else {
                String lowercasePath = path.toString().toLowerCase();
                if (!lowercasePath.endsWith(".cql")) {
                    throw new IllegalArgumentException("Unrecognised file type: " + path);
                }
                List<String> cqlStatements = CqlFileParser.getCqlStatementsFrom(path);
                CqlLoader.load(SchemaLoader.this.sessionContext, cqlStatements);
                SchemaLoader.this.schemaUpdates.add(filename, path);
                LOGGER.info("Applied: {}", (Object)path.getFileName());
            }
        }
    }
}

