/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.nio.file.Path;
import java.util.Objects;
import uk.sky.cqlmigrate.ChecksumCalculator;
import uk.sky.cqlmigrate.SessionContext;

class SchemaChecker {
    public static final String SCHEMA_UPDATES_TABLE = "schema_updates";
    private static final String CHECKSUM_COLUMN = "checksum";
    private final SessionContext sessionContext;
    private final String keyspace;

    SchemaChecker(SessionContext sessionContext, String keyspace) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
    }

    boolean alreadyApplied(String filename) {
        Row row = this.getSchemaUpdate(this.sessionContext.getSession(), filename);
        return row != null;
    }

    private Row getSchemaUpdate(CqlSession session, String filename) {
        return (Row)session.execute(SimpleStatement.newInstance((String)("SELECT * FROM " + this.keyspace + "." + SCHEMA_UPDATES_TABLE + " where filename = ?"), (Object[])new Object[]{filename}).setConsistencyLevel(this.sessionContext.getReadConsistencyLevel())).one();
    }

    boolean contentsAreDifferent(String filename, Path path) {
        Row row = Objects.requireNonNull(this.getSchemaUpdate(this.sessionContext.getSession(), filename));
        String previousSha1 = row.getString(CHECKSUM_COLUMN);
        try {
            String checksum = ChecksumCalculator.calculateChecksum(path);
            return !previousSha1.equals(checksum);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

