/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CassandraLockConfig;
import uk.sky.cqlmigrate.CqlMigrator;
import uk.sky.cqlmigrate.CqlMigratorConfig;
import uk.sky.cqlmigrate.CqlMigratorFactory;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.KeyspaceBootstrapper;
import uk.sky.cqlmigrate.Lock;
import uk.sky.cqlmigrate.LockConfig;
import uk.sky.cqlmigrate.LockingMechanism;
import uk.sky.cqlmigrate.PreMigrationChecker;
import uk.sky.cqlmigrate.SchemaChecker;
import uk.sky.cqlmigrate.SchemaLoader;
import uk.sky.cqlmigrate.SchemaUpdates;
import uk.sky.cqlmigrate.SessionContext;
import uk.sky.cqlmigrate.SessionContextFactory;

final class CqlMigratorImpl
implements CqlMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CqlMigratorImpl.class);
    private final CqlMigratorConfig cqlMigratorConfig;
    private final SessionContextFactory sessionContextFactory;

    CqlMigratorImpl(CqlMigratorConfig cqlMigratorConfig, SessionContextFactory sessionContextFactory) {
        this.cqlMigratorConfig = cqlMigratorConfig;
        this.sessionContextFactory = sessionContextFactory;
    }

    public static void main(String[] args) {
        String hosts = System.getProperty("hosts");
        String localDC = System.getProperty("localDC");
        String keyspace = System.getProperty("keyspace");
        String directoriesProperty = System.getProperty("directories");
        String port = System.getProperty("port");
        String username = System.getProperty("username");
        String password = System.getProperty("password");
        String precheck = System.getProperty("precheck", "false");
        Objects.requireNonNull(hosts, "'hosts' property should be provided having value of a comma separated list of cassandra hosts");
        Objects.requireNonNull(localDC, "'localDC' property should be provided having value of local datacenter for the contact points mentioned in the hosts; the local datacenter must be the same for all contact points");
        Objects.requireNonNull(keyspace, "'keyspace' property should be provided having value of the cassandra keyspace");
        Objects.requireNonNull(directoriesProperty, "'directories' property should be provided having value of the comma separated list of paths to cql files");
        Collection directories = Arrays.stream(directoriesProperty.split(",")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        CqlMigratorFactory.create(CassandraLockConfig.builder().build()).migrate(hosts.split(","), localDC, port == null ? 9042 : Integer.parseInt(port), username, password, keyspace, directories, Boolean.parseBoolean(precheck));
    }

    @Override
    public void migrate(String[] hosts, String localDC, int port, String username, String password, String keyspace, Collection<Path> directories, boolean performPrechecks) {
        List cassandraHosts = Stream.of(hosts).map(host -> new InetSocketAddress((String)host, port)).collect(Collectors.toList());
        try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoints(cassandraHosts)).withLocalDatacenter(localDC)).withAuthCredentials(username, password)).build();){
            this.migrate(cqlSession, keyspace, directories, performPrechecks);
        }
    }

    @Override
    public void migrate(CqlSession session, String keyspace, Collection<Path> directories, boolean performPrechecks) {
        LockingMechanism lockingMechanism = this.cqlMigratorConfig.getCassandraLockConfig().getLockingMechanism(session, keyspace);
        LockConfig lockConfig = this.cqlMigratorConfig.getCassandraLockConfig();
        SessionContext sessionContext = this.sessionContextFactory.getInstance(session, this.cqlMigratorConfig);
        SchemaChecker schemaChecker = new SchemaChecker(sessionContext, keyspace);
        LOGGER.info("Loading cql files from {}", directories);
        CqlPaths paths = CqlPaths.create(directories);
        if (performPrechecks) {
            PreMigrationChecker preMigrationChecker = new PreMigrationChecker(sessionContext, keyspace, schemaChecker, paths);
            if (!preMigrationChecker.migrationIsNeeded()) {
                LOGGER.info("Migration not needed as environment matches expected state");
                return;
            }
            LOGGER.info("Pre-migration checks completed, migration is needed. Continuing...");
        }
        boolean migrationFailed = false;
        Lock lock = new Lock(lockingMechanism, lockConfig);
        lock.lock();
        try {
            KeyspaceBootstrapper keyspaceBootstrapper = new KeyspaceBootstrapper(sessionContext, keyspace, paths);
            SchemaUpdates schemaUpdates = new SchemaUpdates(sessionContext, keyspace);
            SchemaLoader schemaLoader = new SchemaLoader(sessionContext, keyspace, schemaUpdates, schemaChecker, paths);
            keyspaceBootstrapper.bootstrap();
            schemaUpdates.initialise();
            schemaLoader.load();
        }
        catch (Exception e) {
            migrationFailed = true;
            throw e;
        }
        finally {
            lock.unlock(migrationFailed);
        }
    }

    @Override
    public void clean(String[] hosts, String localDC, int port, String username, String password, String keyspace) {
        List cassandraHosts = Stream.of(hosts).map(host -> new InetSocketAddress((String)host, port)).collect(Collectors.toList());
        try (CqlSession cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoints(cassandraHosts)).withLocalDatacenter(localDC)).withAuthCredentials(username, password)).build();){
            this.clean((Session)cqlSession, keyspace);
        }
    }

    @Override
    public void clean(Session session, String keyspace) {
        session.execute((Request)((SimpleStatement)SimpleStatement.newInstance((String)("DROP KEYSPACE IF EXISTS " + keyspace)).setConsistencyLevel(this.cqlMigratorConfig.getWriteConsistencyLevel())), Statement.SYNC);
        LOGGER.info("Cleaned {}", (Object)keyspace);
    }
}

