/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.nio.file.Path;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.ChecksumCalculator;
import uk.sky.cqlmigrate.CqlLoader;
import uk.sky.cqlmigrate.SessionContext;

class SchemaUpdates {
    public static final String SCHEMA_UPDATES_TABLE = "schema_updates";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUpdates.class);
    private static final String CHECKSUM_COLUMN = "checksum";
    private final SessionContext sessionContext;
    private final String keyspace;

    SchemaUpdates(SessionContext sessionContext, String keyspace) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
    }

    void initialise() {
        CqlSession session = this.sessionContext.getSession();
        session.execute(SimpleStatement.newInstance((String)("USE " + this.keyspace + ";")).setConsistencyLevel(this.sessionContext.getReadConsistencyLevel()));
        TableMetadata schemaUpdateTableMetadata = session.getMetadata().getKeyspace(this.keyspace).flatMap(k -> k.getTable(SCHEMA_UPDATES_TABLE)).orElse(null);
        if (schemaUpdateTableMetadata == null) {
            CqlLoader.load(this.sessionContext, Collections.singletonList("CREATE TABLE schema_updates (filename text primary key, checksum text, applied_on timestamp);"));
        }
    }

    void add(String filename, Path path) {
        String query = "INSERT INTO schema_updates (filename, checksum, applied_on) VALUES (?, ?, dateof(now()));";
        Statement statement = SimpleStatement.newInstance((String)query, (Object[])new Object[]{filename, ChecksumCalculator.calculateChecksum(path)}).setConsistencyLevel(this.sessionContext.getWriteConsistencyLevel());
        LOGGER.debug("Applying schema cql: {} path: {}", (Object)query, (Object)path);
        this.sessionContext.getSession().execute(statement);
    }
}

