/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.SchemaChecker;
import uk.sky.cqlmigrate.SessionContext;

public class PreMigrationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreMigrationChecker.class);
    private final SessionContext sessionContext;
    private final String keyspace;
    private final SchemaChecker schemaChecker;
    private final CqlPaths paths;

    public PreMigrationChecker(SessionContext sessionContext, String keyspace, SchemaChecker schemaChecker, CqlPaths paths) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
        this.schemaChecker = schemaChecker;
        this.paths = paths;
    }

    boolean migrationIsNeeded() {
        return !this.keyspaceExists() || !this.schemaUpdatesTableExists() || !this.allMigrationFilesApplied();
    }

    private boolean keyspaceExists() {
        return this.sessionContext.getSession().getMetadata().getKeyspace(this.keyspace).isPresent();
    }

    private boolean schemaUpdatesTableExists() {
        if (this.keyspaceExists()) {
            return this.sessionContext.getSession().getMetadata().getKeyspace(this.keyspace).flatMap(keyspaceMetadata -> keyspaceMetadata.getTable("schema_updates")).isPresent();
        }
        return false;
    }

    private boolean allMigrationFilesApplied() {
        ArrayList filesNotApplied = new ArrayList();
        this.paths.applyInSortedOrder((filename, path) -> {
            if (this.schemaChecker.alreadyApplied(filename)) {
                if (this.schemaChecker.contentsAreDifferent(filename, path)) {
                    LOGGER.error("Contents have changed: {}", (Object)path.getFileName());
                    throw new IllegalStateException("Pre-migration check detected that contents have changed for " + filename + " at " + path);
                }
                LOGGER.info("Already applied: {}, skipping", (Object)path.getFileName());
            } else {
                filesNotApplied.add(filename);
            }
        });
        LOGGER.info("Found {} files to be applied", (Object)filesNotApplied.size());
        return filesNotApplied.isEmpty();
    }
}

