/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.LockConfig;
import uk.sky.cqlmigrate.LockingMechanism;
import uk.sky.cqlmigrate.RetryTask;
import uk.sky.cqlmigrate.exception.CannotAcquireLockException;
import uk.sky.cqlmigrate.exception.CannotReleaseLockException;

class Lock {
    private static final Logger log = LoggerFactory.getLogger(Lock.class);
    private final LockingMechanism lockingMechanism;
    private final LockConfig lockConfig;

    Lock(LockingMechanism lockingMechanism, LockConfig lockConfig) {
        this.lockingMechanism = lockingMechanism;
        this.lockConfig = lockConfig;
    }

    public void lock() throws CannotAcquireLockException {
        this.lockingMechanism.init();
        String lockName = this.lockingMechanism.getLockName();
        String clientId = this.lockConfig.getClientId();
        try {
            log.info("Attempting to acquire lock for '{}', using client id '{}'", (Object)lockName, (Object)this.lockConfig.getClientId());
            RetryTask.attempt(() -> this.lockingMechanism.acquire(clientId)).withTimeout(this.lockConfig.getTimeout()).withPollingInterval(this.lockConfig.getPollingInterval()).untilSuccess();
        }
        catch (TimeoutException te) {
            log.warn("Unable to acquire lock for {}", (Object)this.lockConfig.getClientId(), (Object)te);
            throw new CannotAcquireLockException("Lock currently in use", te);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CannotAcquireLockException(String.format("Polling to acquire lock %s for client %s was interrupted", lockName, this.lockConfig.getClientId()), e);
        }
    }

    public void unlock(boolean migrationFailed) throws CannotReleaseLockException {
        String lockName = this.lockingMechanism.getLockName();
        if (migrationFailed && !this.lockConfig.unlockOnFailure()) {
            log.info("Not releasing the lock for name '{}' and client id '{}' due to failure (use LockConfig.unlockOnFailure() to change that behavior)", (Object)this.lockingMechanism.getLockName(), (Object)this.lockConfig.getClientId());
            return;
        }
        try {
            log.info("Attempting to release lock for '{}', using client id '{}'", (Object)lockName, (Object)this.lockConfig.getClientId());
            RetryTask.attempt(() -> this.lockingMechanism.release(this.lockConfig.getClientId())).withTimeout(this.lockConfig.getTimeout()).withPollingInterval(this.lockConfig.getPollingInterval()).untilSuccess();
        }
        catch (TimeoutException te) {
            log.warn("Unable to release lock for {}", (Object)this.lockConfig.getClientId(), (Object)te);
            throw new CannotReleaseLockException("Failed to release lock", te);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CannotReleaseLockException(String.format("Polling to release lock %s for client %s was interrupted", lockName, this.lockConfig.getClientId()), e);
        }
    }
}

