/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import uk.sky.cqlmigrate.ClusterHealth;

class SessionContext {
    private final Session session;
    private final ConsistencyLevel readConsistencyLevel;
    private final ConsistencyLevel writeConsistencyLevel;
    private final ClusterHealth clusterHealth;
    private boolean clusterHealthChecked = false;

    SessionContext(Session session, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel, ClusterHealth clusterHealth) {
        this.session = session;
        this.readConsistencyLevel = readConsistencyLevel;
        this.writeConsistencyLevel = writeConsistencyLevel;
        this.clusterHealth = clusterHealth;
    }

    public Session getSession() {
        return this.session;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void checkClusterHealth() {
        if (!this.clusterHealthChecked) {
            this.clusterHealth.check();
            this.clusterHealthChecked = true;
        }
    }
}

