/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.SimpleStatement;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.CqlFileParser;
import uk.sky.cqlmigrate.CqlLoader;
import uk.sky.cqlmigrate.CqlPaths;
import uk.sky.cqlmigrate.SchemaUpdates;
import uk.sky.cqlmigrate.SessionContext;

class SchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);
    private final SessionContext sessionContext;
    private final String keyspace;
    private final SchemaUpdates schemaUpdates;
    private final CqlPaths paths;

    SchemaLoader(SessionContext sessionContext, String keyspace, SchemaUpdates schemaUpdates, CqlPaths paths) {
        this.sessionContext = sessionContext;
        this.keyspace = keyspace;
        this.schemaUpdates = schemaUpdates;
        this.paths = paths;
    }

    void load() {
        this.sessionContext.getSession().execute(new SimpleStatement("USE " + this.keyspace + ";").setConsistencyLevel(this.sessionContext.getReadConsistencyLevel()));
        this.paths.applyInSortedOrder(new Loader());
    }

    private class Loader
    implements CqlPaths.Function {
        private Loader() {
        }

        @Override
        public void apply(String filename, Path path) {
            if (SchemaLoader.this.schemaUpdates.alreadyApplied(filename)) {
                if (SchemaLoader.this.schemaUpdates.contentsAreDifferent(filename, path)) {
                    LOGGER.error("Contents have changed: {}", (Object)path.getFileName());
                    throw new IllegalStateException("Contents have changed for " + filename + " at " + path);
                }
                LOGGER.info("Skipped: {}", (Object)path.getFileName());
            } else {
                String lowercasePath = path.toString().toLowerCase();
                if (!lowercasePath.endsWith(".cql")) {
                    throw new IllegalArgumentException("Unrecognised file type: " + path);
                }
                List<String> cqlStatements = CqlFileParser.getCqlStatementsFrom(path);
                CqlLoader.load(SchemaLoader.this.sessionContext, cqlStatements);
                SchemaLoader.this.schemaUpdates.add(filename, path);
                LOGGER.info("Applied: {}", (Object)path.getFileName());
            }
        }
    }
}

