/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.Session;
import java.time.Duration;
import java.util.UUID;
import uk.sky.cqlmigrate.LockingMechanism;

public class LockConfig {
    protected final Duration pollingInterval;
    protected final Duration timeout;
    protected final String clientId;
    protected final boolean unlockOnFailure;

    protected LockConfig(Duration pollingInterval, Duration timeout, String clientId, boolean unlockOnFailure) {
        this.pollingInterval = pollingInterval;
        this.timeout = timeout;
        this.clientId = clientId;
        this.unlockOnFailure = unlockOnFailure;
    }

    Duration getPollingInterval() {
        return this.pollingInterval;
    }

    Duration getTimeout() {
        return this.timeout;
    }

    String getClientId() {
        return this.clientId;
    }

    boolean unlockOnFailure() {
        return this.unlockOnFailure;
    }

    public LockingMechanism getLockingMechanism(Session session, String keySpace) {
        throw new UnsupportedOperationException();
    }

    public static LockConfigBuilder builder() {
        return new LockConfigBuilder();
    }

    public static class LockConfigBuilder {
        protected Duration pollingInterval = Duration.ofMillis(500L);
        protected Duration timeout = Duration.ofMinutes(1L);
        protected String clientId = UUID.randomUUID().toString();
        protected boolean unlockOnFailure;

        protected LockConfigBuilder() {
        }

        public LockConfigBuilder withPollingInterval(Duration pollingInterval) {
            if (pollingInterval.toMillis() < 0L) {
                throw new IllegalArgumentException("Polling interval must be positive: " + pollingInterval.toMillis());
            }
            this.pollingInterval = pollingInterval;
            return this;
        }

        public LockConfigBuilder withTimeout(Duration timeout) {
            if (timeout.toMillis() < 0L) {
                throw new IllegalArgumentException("Timeout must be positive: " + timeout.toMillis());
            }
            this.timeout = timeout;
            return this;
        }

        public LockConfigBuilder unlockOnFailure() {
            this.unlockOnFailure = true;
            return this;
        }

        public LockConfig build() {
            return new LockConfig(this.pollingInterval, this.timeout, this.clientId, this.unlockOnFailure);
        }
    }
}

