/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.exception.ClusterUnhealthyException;

class ClusterHealth {
    private static final Logger log = LoggerFactory.getLogger(ClusterHealth.class);
    private final Cluster cluster;

    ClusterHealth(Cluster cluster) {
        this.cluster = cluster;
    }

    void check() throws ClusterUnhealthyException {
        log.debug("Checking cluster health");
        Set allHosts = this.cluster.getMetadata().getAllHosts();
        List unhealthyHosts = allHosts.stream().filter(host -> !host.isUp()).map(Host::getAddress).collect(Collectors.toList());
        if (!unhealthyHosts.isEmpty()) {
            throw new ClusterUnhealthyException("Cluster not healthy, the following hosts are down: " + unhealthyHosts);
        }
        log.debug("All hosts healthy: {}", (Object)allHosts);
    }
}

