/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.messaging.component;

import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.concurrent.ConcurrencySupport;
import uk.org.retep.util.messaging.Component;
import uk.org.retep.util.messaging.ComponentAlreadyAttachedException;
import uk.org.retep.util.messaging.Message;
import uk.org.retep.util.messaging.MessageException;
import uk.org.retep.util.messaging.MessagingService;
import uk.org.retep.util.messaging.MessagingServiceUnavailableException;

@ThreadSafe
public abstract class AbstractComponent<K, M extends Message<K>>
extends ConcurrencySupport
implements Component<K, M> {
    private MessagingService<K, ?> messagingService;
    private boolean started;
    private K key;

    public AbstractComponent() {
        this(null);
    }

    public AbstractComponent(K key) {
        this.key = key;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    protected final MessagingService<K, ?> getMessagingService() {
        this.readLock().lock();
        try {
            MessagingService<K, ?> messagingService = this.messagingService;
            return messagingService;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public final void setMessagingService(MessagingService<K, ?> messagingService) throws MessageException {
        block5: {
            this.writeLock().lock();
            try {
                if (this.messagingService == null || messagingService == null) {
                    this.messagingService = messagingService;
                    this.messagingServiceUpdated();
                    break block5;
                }
                if (!this.messagingService.equals(messagingService)) {
                    this.messagingServiceUpdated();
                    break block5;
                }
                throw new ComponentAlreadyAttachedException();
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    protected void messagingServiceUpdated() throws MessageException {
    }

    public final void send(Message<K> message) throws MessageException {
        MessagingService<K, ?> service = this.getMessagingService();
        if (service == null) {
            throw new MessagingServiceUnavailableException();
        }
        service.send(message);
    }

    @Override
    public void startComponent() throws MessageException {
        this.setComponentStarted(true);
        this.getLog().debug("Started %s", this);
    }

    @Override
    public void stopComponent() {
        this.setComponentStarted(false);
        this.getLog().debug("Stopped %s", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public final boolean isComponentStarted() {
        this.readLock().lock();
        try {
            boolean bl = this.started;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    protected final void setComponentStarted(boolean started) {
        this.writeLock().lock();
        try {
            this.started = started;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public String toString() {
        if (this.key == null) {
            return super.toString();
        }
        return this.getClass().getName() + "[" + this.key + "]";
    }

    public int hashCode() {
        if (this.key == null) {
            return super.hashCode();
        }
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractComponent other = (AbstractComponent)obj;
        return this.key == other.key || this.key != null && this.key.equals(other.key);
    }
}

