/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Contract;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.reference.AbstractDelayedWeakReference;

@ThreadSafe
public class DelayedWeakLinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable {
    protected static final long DEFAULT_DELAY = 15000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final long delay;
    private Entry header = new Header();
    private int size = 0;

    public DelayedWeakLinkedList() {
        this(15000L);
    }

    public DelayedWeakLinkedList(long delay) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("Delay must be > 0");
        }
        this.delay = delay;
        this.header.next = this.header.previous = this.header;
    }

    public DelayedWeakLinkedList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public DelayedWeakLinkedList(long delay, Collection<? extends E> c) {
        this(delay);
        this.addAll(c);
    }

    @Contract(value={ReadLock.class})
    protected final Lock readLock() {
        return this.lock.readLock();
    }

    @Contract(value={WriteLock.class})
    protected final Lock writeLock() {
        return this.lock.writeLock();
    }

    public final long getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E getFirst() {
        this.readLock().lock();
        try {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Object t = this.header.next.get();
            return (E)t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E getLast() {
        this.readLock().lock();
        try {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Object t = this.header.previous.get();
            return (E)t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E removeFirst() {
        this.writeLock().lock();
        try {
            E e = this.removeEntry(this.header.next);
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E removeLast() {
        this.writeLock().lock();
        try {
            E e = this.removeEntry(this.header.previous);
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void addFirst(E e) {
        this.writeLock().lock();
        try {
            this.addBefore(e, this.header.next);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void addLast(E e) {
        this.writeLock().lock();
        try {
            this.addBefore(e, this.header);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean contains(Object o) {
        this.readLock().lock();
        try {
            boolean bl = this.indexOf(o) != -1;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int size() {
        this.readLock().lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean add(E e) {
        this.writeLock().lock();
        try {
            this.addBefore(e, this.header);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean remove(Object o) {
        this.writeLock().lock();
        try {
            Entry e;
            if (o == null) {
                e = this.header.next;
                while (e != this.header) {
                    if (e.get() == null) {
                        this.removeEntry(e);
                        boolean bl = true;
                        return bl;
                    }
                    e = e.next;
                }
            } else {
                e = this.header.next;
                while (e != this.header) {
                    if (o.equals(e.get())) {
                        this.removeEntry(e);
                        boolean bl = true;
                        return bl;
                    }
                    e = e.next;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            for (E a : c) {
                this.addBefore(a, this.header);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(int index, Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            Entry e = this.entry((int)index).next;
            for (E a : c) {
                e = this.addBefore(a, e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void clear() {
        this.writeLock().lock();
        try {
            Entry e = this.header.next;
            while (e != this.header) {
                Entry next = e.next;
                e.recordRemoval(this);
                e = next;
            }
            this.header.next = this.header.previous = this.header;
            this.size = 0;
            ++this.modCount;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E get(int index) {
        this.readLock().lock();
        try {
            Object t = this.entry(index).get();
            return (E)t;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E set(int index, E element) {
        this.writeLock().lock();
        try {
            Entry e = this.entry(index);
            Object v = e.get();
            this.replaceEntry(e, element);
            Object t = v;
            return (E)t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void add(int index, E element) {
        this.writeLock().lock();
        try {
            this.addBefore(element, index == this.size ? this.header : this.entry(index));
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E remove(int index) {
        this.writeLock().lock();
        try {
            E e = this.removeEntry(this.entry(index));
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private Entry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size >> 1) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int indexOf(Object o) {
        this.readLock().lock();
        try {
            Entry e;
            int index = 0;
            if (o == null) {
                e = this.header.next;
                while (e != this.header) {
                    if (e.get() == null) {
                        int n = index;
                        return n;
                    }
                    ++index;
                    e = e.next;
                }
            } else {
                e = this.header.next;
                while (e != this.header) {
                    if (o.equals(e.get())) {
                        int n = index;
                        return n;
                    }
                    ++index;
                    e = e.next;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int lastIndexOf(Object o) {
        this.readLock().lock();
        try {
            Entry e;
            int index = this.size;
            if (o == null) {
                e = this.header.previous;
                while (e != this.header) {
                    --index;
                    if (e.get() == null) {
                        int n = index;
                        return n;
                    }
                    e = e.previous;
                }
            } else {
                e = this.header.previous;
                while (e != this.header) {
                    --index;
                    if (o.equals(e.get())) {
                        int n = index;
                        return n;
                    }
                    e = e.previous;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E peek() {
        this.readLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.getFirst();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E element() {
        this.readLock().lock();
        try {
            E e = this.getFirst();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E poll() {
        this.writeLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.removeFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E remove() {
        this.writeLock().lock();
        try {
            E e = this.removeFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean offer(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.add(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean offerFirst(E e) {
        this.writeLock().lock();
        try {
            this.addFirst(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean offerLast(E e) {
        this.writeLock().lock();
        try {
            this.addLast(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E peekFirst() {
        this.readLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.getFirst();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public E peekLast() {
        this.readLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.getLast();
            return e;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E pollFirst() {
        this.writeLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.removeFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E pollLast() {
        this.writeLock().lock();
        try {
            if (this.size == 0) {
                E e = null;
                return e;
            }
            E e = this.removeLast();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void push(E e) {
        this.writeLock().lock();
        try {
            this.addFirst(e);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public E pop() {
        this.writeLock().lock();
        try {
            E e = this.removeFirst();
            return e;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean removeFirstOccurrence(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.remove(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean removeLastOccurrence(Object o) {
        this.writeLock().lock();
        try {
            Entry e;
            if (o == null) {
                e = this.header.previous;
                while (e != this.header) {
                    if (e.get() == null) {
                        this.removeEntry(e);
                        boolean bl = true;
                        return bl;
                    }
                    e = e.previous;
                }
            } else {
                e = this.header.previous;
                while (e != this.header) {
                    if (o.equals(e.get())) {
                        this.removeEntry(e);
                        boolean bl = true;
                        return bl;
                    }
                    e = e.previous;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public ListIterator<E> listIterator(int index) {
        this.readLock().lock();
        try {
            ListItr listItr = new ListItr(index);
            return listItr;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected Entry createEntry(E element, Entry next, Entry previous) {
        return new Entry(element, next, previous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    private Entry addBefore(E e, Entry entry) {
        this.writeLock().lock();
        try {
            Entry newEntry;
            if (e == null) {
                throw new NullPointerException();
            }
            newEntry.previous.next = newEntry = this.createEntry(e, entry, entry.previous);
            newEntry.next.previous = newEntry;
            ++this.size;
            ++this.modCount;
            Entry entry2 = newEntry;
            return entry2;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    final E removeEntry(Entry e) {
        this.writeLock().lock();
        try {
            if (e == this.header) {
                throw new NoSuchElementException();
            }
            Object result = e.get();
            if (e.previous != null && e.next != null) {
                e.previous.next = e.next;
                e.next.previous = e.previous;
                --this.size;
                ++this.modCount;
            }
            e.recordRemoval(this);
            Object t = result;
            return (E)t;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    final Entry replaceEntry(Entry e, E n) {
        this.writeLock().lock();
        try {
            Entry newEntry;
            if (e == null || n == null) {
                throw new NullPointerException();
            }
            newEntry.previous.next = newEntry = this.createEntry(n, e.next, e.previous);
            newEntry.next.previous = newEntry;
            e.previous = null;
            e.next = null;
            e.getAndRelease();
            Entry entry = newEntry;
            return entry;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @ReadLock
    public Object clone() {
        this.readLock().lock();
        try {
            DelayedWeakLinkedList clone = (DelayedWeakLinkedList)super.clone();
            clone.header.next = clone.header.previous = (clone.header = new Header());
            clone.size = 0;
            clone.modCount = 0;
            Entry e = this.header.next;
            while (e != this.header) {
                clone.add(e.get());
                e = e.next;
            }
            DelayedWeakLinkedList delayedWeakLinkedList = clone;
            return delayedWeakLinkedList;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Object[] toArray() {
        this.readLock().lock();
        try {
            Object[] result = new Object[this.size];
            int i = 0;
            Entry e = this.header.next;
            while (e != this.header) {
                result[i++] = e.get();
                e = e.next;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public <T> T[] toArray(T[] a) {
        this.readLock().lock();
        try {
            T[] ary;
            T[] result = ary = this.createArray(a, this.size);
            int i = 0;
            Entry e = this.header.next;
            while (e != this.header) {
                result[i++] = e.get();
                e = e.next;
            }
            if (ary.length > this.size) {
                ary[this.size] = null;
            }
            T[] TArray = ary;
            return TArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    private <T> T[] createArray(T[] a, int size) {
        if (a.length < size) {
            return (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        return a;
    }

    private class DescendingIterator
    implements Iterator<E> {
        final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(DelayedWeakLinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected class Entry
    extends AbstractDelayedWeakReference<E> {
        Entry next;
        Entry previous;

        public Entry(E element, Entry next, Entry previous) {
            super(DelayedWeakLinkedList.this.getDelay(), element);
            this.next = next;
            this.previous = previous;
        }

        protected <T extends DelayedWeakLinkedList<E>> void recordRemoval(T collection) {
            this.previous = null;
            this.next = null;
            this.getAndRelease();
        }

        @Override
        protected void remove(E o) {
            DelayedWeakLinkedList.this.removeEntry(this);
        }
    }

    private final class Header
    extends Entry {
        Header() {
            super(null, null, null);
            this.getAndRelease();
        }

        @Override
        protected void remove(E o) {
        }
    }

    @ThreadSafe
    private class ListItr
    implements ListIterator<E> {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.lastReturned = DelayedWeakLinkedList.this.header;
            this.expectedModCount = DelayedWeakLinkedList.this.modCount;
            if (index < 0 || index > DelayedWeakLinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + DelayedWeakLinkedList.this.size);
            }
            this.nextIndex = index;
        }

        @Contract(value={ReadLock.class})
        protected final Lock readLock() {
            return DelayedWeakLinkedList.this.readLock();
        }

        @Contract(value={WriteLock.class})
        protected final Lock writeLock() {
            return DelayedWeakLinkedList.this.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public boolean hasNext() {
            this.readLock().lock();
            try {
                boolean bl = this.nextIndex < DelayedWeakLinkedList.this.size;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public E next() {
            this.writeLock().lock();
            try {
                Entry e;
                if (this.nextIndex >= DelayedWeakLinkedList.this.size) {
                    throw new NoSuchElementException();
                }
                if ((e = DelayedWeakLinkedList.this.entry(this.nextIndex++)) == DelayedWeakLinkedList.this.header) {
                    throw new NoSuchElementException();
                }
                Object t = e.get();
                return t;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public boolean hasPrevious() {
            this.readLock().lock();
            try {
                boolean bl = this.nextIndex != 0;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public E previous() {
            this.writeLock().lock();
            try {
                Entry e;
                if (this.nextIndex <= 0) {
                    throw new NoSuchElementException();
                }
                if ((e = DelayedWeakLinkedList.this.entry(--this.nextIndex)) == DelayedWeakLinkedList.this.header) {
                    throw new NoSuchElementException();
                }
                Object t = e.get();
                return t;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public int nextIndex() {
            this.readLock().lock();
            try {
                int n = this.nextIndex;
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public int previousIndex() {
            this.readLock().lock();
            try {
                int n = this.nextIndex - 1;
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public void remove() {
            this.writeLock().lock();
            try {
                if (this.nextIndex < 0 || this.nextIndex >= DelayedWeakLinkedList.this.size) {
                    throw new IllegalStateException();
                }
                Entry e = DelayedWeakLinkedList.this.entry(this.nextIndex);
                if (e == DelayedWeakLinkedList.this.header) {
                    throw new NoSuchElementException();
                }
                DelayedWeakLinkedList.this.removeEntry(e);
                --this.nextIndex;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public void set(E e) {
            this.writeLock().lock();
            try {
                if (this.nextIndex > DelayedWeakLinkedList.this.size) {
                    throw new NoSuchElementException();
                }
                Entry en = DelayedWeakLinkedList.this.entry(this.nextIndex - 1);
                if (en == DelayedWeakLinkedList.this.header) {
                    throw new NoSuchElementException();
                }
                DelayedWeakLinkedList.this.replaceEntry(en, e);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public void add(E e) {
            this.writeLock().lock();
            try {
                if (this.nextIndex > DelayedWeakLinkedList.this.size) {
                    throw new NoSuchElementException();
                }
                Entry en = DelayedWeakLinkedList.this.entry(this.nextIndex);
                DelayedWeakLinkedList.this.addBefore(e, en);
                ++this.nextIndex;
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }
}

