/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.messaging.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.messaging.Component;
import uk.org.retep.util.messaging.Message;
import uk.org.retep.util.messaging.MessageException;
import uk.org.retep.util.messaging.MessageNotRoutableException;
import uk.org.retep.util.messaging.Router;
import uk.org.retep.util.messaging.component.AbstractComponent;
import uk.org.retep.util.messaging.message.SimpleMessage;

@ThreadSafe
public abstract class AbstractRouter<K, R>
extends AbstractComponent<K, Message<K>>
implements Router<K, R> {
    private final Map<R, Component<K, Message<K>>> routes = new HashMap<R, Component<K, Message<K>>>();

    public AbstractRouter() {
    }

    public AbstractRouter(K key) {
        super(key);
    }

    @Override
    public final void add(Component<K, Message<K>> component) throws MessageException {
        if (component == null || component.getKey() == null) {
            throw new MessageException("Component not capable of dynamic addition");
        }
        this.consume(new AddRouteMessage<K>(component.getKey(), component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Collection<R> getRoutes() {
        this.readLock().lock();
        try {
            ArrayList<R> arrayList = new ArrayList<R>(this.routes.keySet());
            return arrayList;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public final boolean addRoute(R route, Component<K, ?> component) throws MessageException {
        this.writeLock().lock();
        try {
            if (this.routes.containsKey(route)) {
                this.getLog().warn("Route %s already exists", route);
                boolean bl = false;
                return bl;
            }
            component.setMessagingService(this.getMessagingService());
            if (this.isComponentStarted() && !component.isComponentStarted()) {
                component.startComponent();
            }
            this.routes.put(route, component);
            this.componentAdded(component);
            this.getLog().debug("Added Route %s to %s", route, component);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public final boolean containsRoute(R route) {
        this.readLock().lock();
        try {
            boolean bl = this.routes.containsKey(route);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public final boolean removeRoute(R route) {
        this.writeLock().lock();
        try {
            Component component = this.routes.remove(route);
            if (component != null && !this.routes.containsValue(component) && component.isComponentStarted()) {
                component.stopComponent();
                try {
                    component.setMessagingService(null);
                }
                catch (MessageException messageException) {
                    // empty catch block
                }
                this.getLog().debug("Removed route %s", route);
            }
            boolean bl = component != null;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public final boolean removeComponent(Component<K, ?> component) {
        this.writeLock().lock();
        try {
            boolean removed = false;
            Collection<Component<K, Message<K>>> comps = this.routes.values();
            while (comps.remove(component)) {
                removed = true;
            }
            if (removed && component.isComponentStarted()) {
                component.stopComponent();
                try {
                    component.setMessagingService(null);
                }
                catch (MessageException ex) {
                    // empty catch block
                }
                this.getLog().debug("Removed %s", component);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public void startComponent() throws MessageException {
        if (!this.isComponentStarted()) {
            Collection<Component<K, ?>> comps = this.getComponents();
            if (!comps.isEmpty()) {
                try {
                    for (Component<K, ?> comp : comps) {
                        if (comp.isComponentStarted()) continue;
                        comp.startComponent();
                    }
                }
                catch (MessageException me) {
                    this.stopComponent();
                    throw me;
                }
                catch (RuntimeException re) {
                    this.stopComponent();
                    throw re;
                }
            }
            super.startComponent();
        }
    }

    @Override
    public void stopComponent() {
        if (this.isComponentStarted()) {
            super.stopComponent();
            Collection<Component<K, ?>> comps = this.getComponents();
            if (!comps.isEmpty()) {
                for (Component<K, ?> comp : comps) {
                    if (comp.isComponentStarted()) continue;
                    try {
                        comp.stopComponent();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    protected void componentAdded(Component<K, Message<K>> component) {
    }

    protected void componentRemoved(Component<K, Message<K>> component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public final Collection<Component<K, ?>> getComponents() {
        this.readLock().lock();
        try {
            HashSet hashSet = new HashSet(this.routes.values());
            return hashSet;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected abstract R getRoute(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    protected final Component<K, Message<K>> getComponent(R route) {
        this.readLock().lock();
        try {
            Component<K, Message<K>> component = this.routes.get(route);
            return component;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void consume(Message<K> message) throws MessageException {
        K to = message.getTo();
        R route = this.getRoute(to);
        if (route == null) {
            throw new MessageNotRoutableException("No route for " + to);
        }
        Component<K, Message<K>> component = this.getComponent(route);
        if (message instanceof AddRouteMessage) {
            if (component == null) {
                this.addRoute(message);
                return;
            } else {
                if (!(component instanceof Router)) throw new MessageException("Unable to add " + message.getTo());
                this.getLog().debug("Passing AddRouteMessage to %s", component);
                component.consume(message);
            }
            return;
        } else if (component == null) {
            this.unknownRoute(message);
            return;
        } else {
            this.getLog().debug("Routing %s to %s", route, component);
            component.consume(message);
        }
    }

    private void addRoute(Message<K> message) throws MessageException {
        AddRouteMessage arm = (AddRouteMessage)message;
        R route = this.getRoute(arm.getTo());
        if (!this.addRoute(route, (Component)arm.getPayload())) {
            throw new MessageException("Unable to add " + arm.getTo());
        }
    }

    protected void unknownRoute(Message<K> message) throws MessageException {
        throw new MessageNotRoutableException("No route for " + message.getTo());
    }

    private class AddRouteMessage<K>
    extends SimpleMessage<K, Component<K, Message<K>>> {
        public AddRouteMessage(K key, Component<K, Message<K>> comp) {
            super(key, key, comp);
        }
    }
}

