/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.OutputStream;

class OutWindow {
    private byte[] _buffer;
    private int _pos;
    private int _windowSize = 0;
    private int _streamPos;
    private OutputStream _stream;

    OutWindow() {
    }

    public void create(int windowSize) {
        if (this._buffer == null || this._windowSize != windowSize) {
            this._buffer = new byte[windowSize];
        }
        this._windowSize = windowSize;
        this._pos = 0;
        this._streamPos = 0;
    }

    public void setStream(OutputStream stream) throws IOException {
        this.releaseStream();
        this._stream = stream;
    }

    public void releaseStream() throws IOException {
        this.flush();
        this._stream = null;
    }

    public void init(boolean solid) {
        if (!solid) {
            this._streamPos = 0;
            this._pos = 0;
        }
    }

    public void flush() throws IOException {
        int size = this._pos - this._streamPos;
        if (size == 0) {
            return;
        }
        this._stream.write(this._buffer, this._streamPos, size);
        if (this._pos >= this._windowSize) {
            this._pos = 0;
        }
        this._streamPos = this._pos;
    }

    public void copyBlock(int distance, int length) throws IOException {
        int remaining = length;
        int pos = this._pos - distance - 1;
        if (pos < 0) {
            pos += this._windowSize;
        }
        while (remaining > 0) {
            if (pos >= this._windowSize) {
                pos = 0;
            }
            this._buffer[this._pos++] = this._buffer[pos++];
            if (this._pos >= this._windowSize) {
                this.flush();
            }
            --remaining;
        }
    }

    public void putByte(byte b) throws IOException {
        this._buffer[this._pos++] = b;
        if (this._pos >= this._windowSize) {
            this.flush();
        }
    }

    public byte getByte(int distance) {
        int pos = this._pos - distance - 1;
        if (pos < 0) {
            pos += this._windowSize;
        }
        return this._buffer[pos];
    }
}

