/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.random.RandomSeedGenerator;

@ThreadSafe
public final class RandomSeedGeneratorFactory {
    private static final RandomSeedGeneratorFactory INSTANCE = new RandomSeedGeneratorFactory();
    private static final SortedSet<RandomSeedGenerator> generators = new TreeSet<RandomSeedGenerator>(new Comparator<RandomSeedGenerator>(){

        @Override
        public int compare(RandomSeedGenerator a, RandomSeedGenerator b) {
            return a.getPriority() - b.getPriority();
        }
    });
    private static final Collection<String> generatorNames;

    public static RandomSeedGeneratorFactory getInstance() {
        return INSTANCE;
    }

    public byte[] generateSeed(int seedLength) {
        for (RandomSeedGenerator generator : generators) {
            try {
                return generator.generateSeed(seedLength);
            }
            catch (Exception ex) {
            }
        }
        throw new IllegalStateException("No RandomSeedGenerator implementations were available or all failed");
    }

    public byte[] generateSeed(String name, int seedLength) {
        for (RandomSeedGenerator generator : generators) {
            if (!name.equals(generator.getName())) continue;
            return generator.generateSeed(seedLength);
        }
        throw new IllegalStateException("No RandomSeedGenerator found for name " + name);
    }

    public RandomSeedGenerator getRandomSeedGenerator(String name) {
        for (RandomSeedGenerator generator : generators) {
            if (!name.equals(generator.getName())) continue;
            return generator;
        }
        return null;
    }

    public Collection<String> getGenerators() {
        return generatorNames;
    }

    static {
        ServiceLoader<RandomSeedGenerator> loader = ServiceLoader.load(RandomSeedGenerator.class);
        for (RandomSeedGenerator generator : loader) {
            generators.add(generator);
        }
        ArrayList<String> genNames = new ArrayList<String>(generators.size());
        for (RandomSeedGenerator generator : generators) {
            genNames.add(generator.getName());
        }
        generatorNames = Collections.unmodifiableCollection(genNames);
    }
}

