/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.nio.BindingSocketProcessor;
import uk.org.retep.util.nio.SocketProcessorHandler;

@ThreadSafe
public abstract class DelegatingSocketProcessor
extends BindingSocketProcessor {
    private int defaultCapacity = 8192;

    protected static SocketChannel getSocketChannel(SelectionKey key) {
        return (SocketChannel)key.channel();
    }

    protected final SocketProcessorHandler getSocketProcessorHandler(SelectionKey key) {
        return this.getSocketProcessorHandler(DelegatingSocketProcessor.getSocketChannel(key));
    }

    protected abstract SocketProcessorHandler createSocketProcessorHandler(SocketChannel var1);

    protected abstract SocketProcessorHandler getSocketProcessorHandler(SocketChannel var1);

    protected abstract void closeSocketProcessorHandler(SocketProcessorHandler var1, SocketChannel var2);

    @Override
    protected final void accept(SelectionKey key) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.getDefaultCapacity());
        buffer.clear();
        ServerSocketChannel server = (ServerSocketChannel)ServerSocketChannel.class.cast(key.channel());
        SocketChannel channel = server.accept();
        SocketProcessorHandler handler = this.createSocketProcessorHandler(channel);
        handler.accept(key);
        this.getLog().debug("Accepted connection from %s", channel.socket());
        this.registerChannel(channel, 1, buffer);
    }

    @Override
    protected final void read(SelectionKey key) throws IOException {
        SocketProcessorHandler handler = this.getSocketProcessorHandler(key);
        handler.read(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(SocketProcessorHandler handler, SocketChannel channel) {
        try {
            this.closeSocketProcessorHandler(handler, channel);
            handler.closing(channel);
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException ioe) {
                this.getLog().error((Object)"IOException while closing channel", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    public final int getDefaultCapacity() {
        this.readLock().lock();
        try {
            int n = this.defaultCapacity;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    public final void setDefaultCapacity(int defaultCapacity) {
        this.writeLock().lock();
        try {
            if (defaultCapacity < 256) {
                throw new IllegalArgumentException("Buffer size " + defaultCapacity + "too small");
            }
            this.defaultCapacity = defaultCapacity;
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

