/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class MathUtils {
    private MathUtils() {
    }

    public static Number convert(Object value) throws NumberFormatException {
        if (value == null || value instanceof Number) {
            return (Number)Number.class.cast(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)Boolean.class.cast(value) != false ? 1 : 0;
        }
        String v = value.toString();
        if (v.length() > 0) {
            char c = v.charAt(0);
            if (c == 'f' || c == 'F' || c == 'n' || c == 'N') {
                return 0;
            }
            if (c == 't' || c == 'T' || c == 'y' || c == 'Y') {
                return 1;
            }
        }
        if (v.contains(".")) {
            return new Double(v);
        }
        return new Integer(v);
    }

    public static Number convert(Number required, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            switch (TYPE.getType(required)) {
                case DOUBLE: {
                    return ((Number)Number.class.cast(value)).doubleValue();
                }
                case FLOAT: {
                    return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
                }
                case INTEGER: {
                    return ((Number)Number.class.cast(value)).intValue();
                }
                case LONG: {
                    return ((Number)Number.class.cast(value)).longValue();
                }
                case SHORT: {
                    return ((Number)Number.class.cast(value)).shortValue();
                }
                case BIGDECIMAL: {
                    return new BigDecimal(value.toString());
                }
                case BIGINTEGER: {
                    return new BigInteger(value.toString());
                }
            }
            throw new NumberFormatException("Unable to convert " + value.getClass().getSimpleName() + " to " + required.getClass().getSimpleName());
        }
        String s = value.toString();
        switch (TYPE.getType(required)) {
            case DOUBLE: {
                return new Double(s);
            }
            case FLOAT: {
                return new Float(s);
            }
            case INTEGER: {
                return new Integer(s);
            }
            case LONG: {
                return new Long(s);
            }
            case SHORT: {
                return new Short(s);
            }
            case BIGDECIMAL: {
                return new BigDecimal(s);
            }
            case BIGINTEGER: {
                return new BigInteger(s);
            }
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getSimpleName() + " to " + required.getClass().getSimpleName());
    }

    public static Number add(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case NULL: {
                return null;
            }
            case DOUBLE: {
                return a.doubleValue() + b.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }
            case INTEGER: {
                return a.intValue() + b.intValue();
            }
            case LONG: {
                return a.longValue() + b.longValue();
            }
            case SHORT: {
                return a.shortValue() + b.shortValue();
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).add((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).add((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number subtract(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case NULL: {
                return null;
            }
            case DOUBLE: {
                return a.doubleValue() - b.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() - b.floatValue());
            }
            case INTEGER: {
                return a.intValue() - b.intValue();
            }
            case LONG: {
                return a.longValue() - b.longValue();
            }
            case SHORT: {
                return a.shortValue() - b.shortValue();
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).subtract((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).subtract((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number divide(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case NULL: {
                return null;
            }
            case DOUBLE: {
                return a.doubleValue() / b.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() / b.floatValue());
            }
            case INTEGER: {
                return a.intValue() / b.intValue();
            }
            case LONG: {
                return a.longValue() / b.longValue();
            }
            case SHORT: {
                return a.shortValue() + b.shortValue();
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).divide((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).divide((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number multiply(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case NULL: {
                return null;
            }
            case DOUBLE: {
                return a.doubleValue() * b.doubleValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }
            case INTEGER: {
                return a.intValue() * b.intValue();
            }
            case LONG: {
                return a.longValue() * b.longValue();
            }
            case SHORT: {
                return a.shortValue() + b.shortValue();
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).multiply((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).multiply((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number lessThan(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case NULL: {
                return null;
            }
            case DOUBLE: {
                return a.doubleValue() < b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() < b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() < b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() < b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() < b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).compareTo((BigDecimal)BigDecimal.class.cast(b)) < 0 ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).compareTo((BigInteger)BigInteger.class.cast(b)) < 0 ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number lessEqual(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() <= b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() <= b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() <= b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() <= b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() <= b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).compareTo((BigDecimal)BigDecimal.class.cast(b)) <= 0 ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).compareTo((BigInteger)BigInteger.class.cast(b)) <= 0 ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number equal(Number a, Number b) {
        if (a == null || b == null) {
            return a == b ? 1.0 : 0.0;
        }
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() == b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() == b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() == b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() == b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() == b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).equals(BigDecimal.class.cast(b)) ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).equals(BigInteger.class.cast(b)) ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number notEqual(Number a, Number b) {
        if (a == null || b == null) {
            return a != b ? 1.0 : 0.0;
        }
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() != b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() != b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() != b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() != b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() != b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return !((BigDecimal)BigDecimal.class.cast(a)).equals(BigDecimal.class.cast(b)) ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return !((BigInteger)BigInteger.class.cast(a)).equals(BigInteger.class.cast(b)) ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number greaterEqual(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() >= b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() >= b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() >= b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() >= b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() >= b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).compareTo((BigDecimal)BigDecimal.class.cast(b)) >= 0 ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).compareTo((BigInteger)BigInteger.class.cast(b)) >= 0 ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number greaterThan(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() > b.doubleValue() ? 1.0 : 0.0;
            }
            case FLOAT: {
                return a.floatValue() > b.floatValue() ? 1.0 : 0.0;
            }
            case INTEGER: {
                return a.intValue() > b.intValue() ? 1.0 : 0.0;
            }
            case LONG: {
                return a.longValue() > b.longValue() ? 1.0 : 0.0;
            }
            case SHORT: {
                return a.shortValue() > b.shortValue() ? 1.0 : 0.0;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).compareTo((BigDecimal)BigDecimal.class.cast(b)) > 0 ? 1.0 : 0.0;
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).compareTo((BigInteger)BigInteger.class.cast(b)) > 0 ? 1.0 : 0.0;
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number max(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return Math.max(a.doubleValue(), b.doubleValue());
            }
            case FLOAT: {
                return Float.valueOf(Math.max(a.floatValue(), b.floatValue()));
            }
            case INTEGER: 
            case SHORT: {
                return Math.max(a.intValue(), b.intValue());
            }
            case LONG: {
                return Math.max(a.longValue(), b.longValue());
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).max((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).max((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number min(Number a, Number b) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return Math.min(a.doubleValue(), b.doubleValue());
            }
            case FLOAT: {
                return Float.valueOf(Math.min(a.floatValue(), b.floatValue()));
            }
            case INTEGER: 
            case SHORT: {
                return Math.min(a.intValue(), b.intValue());
            }
            case LONG: {
                return Math.min(a.longValue(), b.longValue());
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).min((BigDecimal)BigDecimal.class.cast(b));
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).min((BigInteger)BigInteger.class.cast(b));
            }
        }
        throw new NumberFormatException("Unable to convert " + b.getClass().getSimpleName() + " to " + a.getClass().getSimpleName());
    }

    public static Number abs(Number a) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return Math.abs(a.doubleValue());
            }
            case FLOAT: {
                return Float.valueOf(Math.abs(a.floatValue()));
            }
            case INTEGER: 
            case SHORT: {
                return Math.abs(a.intValue());
            }
            case LONG: {
                return Math.abs(a.longValue());
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).abs();
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).abs();
            }
        }
        throw new NumberFormatException("Unable to convert " + a.getClass().getSimpleName());
    }

    public static Number ceil(Number a) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return Math.ceil(a.doubleValue());
            }
            case FLOAT: {
                return Math.ceil(a.floatValue());
            }
            case INTEGER: 
            case SHORT: {
                return Math.ceil(a.intValue());
            }
            case LONG: {
                return Math.ceil(a.longValue());
            }
            case BIGDECIMAL: 
            case BIGINTEGER: {
                return a.intValue();
            }
        }
        throw new NumberFormatException("Unable to convert " + a.getClass().getSimpleName());
    }

    public static Number floor(Number a) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return Math.floor(a.doubleValue());
            }
            case FLOAT: {
                return Math.floor(a.floatValue());
            }
            case INTEGER: 
            case SHORT: {
                return Math.floor(a.intValue());
            }
            case LONG: {
                return Math.floor(a.longValue());
            }
            case BIGDECIMAL: 
            case BIGINTEGER: {
                return a.intValue();
            }
        }
        throw new NumberFormatException("Unable to convert " + a.getClass().getSimpleName());
    }

    public static Number integer(Number a) {
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return (a.doubleValue() < 0.0 ? (Number)MathUtils.ceil(a) : (Number)MathUtils.floor(a)).intValue();
            }
            case FLOAT: {
                return (a.floatValue() < 0.0f ? (Number)MathUtils.ceil(a) : (Number)MathUtils.floor(a)).intValue();
            }
            case INTEGER: 
            case SHORT: {
                return a.intValue() < 0 ? (Number)MathUtils.ceil(a) : (Number)MathUtils.floor(a);
            }
            case LONG: {
                return a.longValue() < 0L ? (Number)MathUtils.ceil(a) : (Number)MathUtils.floor(a);
            }
            case BIGDECIMAL: 
            case BIGINTEGER: {
                return a.intValue();
            }
        }
        throw new NumberFormatException("Unable to convert " + a.getClass().getSimpleName());
    }

    public static boolean isTrue(Number a) {
        return a == null ? false : !MathUtils.isFalse(a);
    }

    public static boolean isFalse(Number a) {
        if (a == null) {
            return false;
        }
        switch (TYPE.getType(a)) {
            case DOUBLE: {
                return a.doubleValue() == 0.0;
            }
            case FLOAT: {
                return a.floatValue() == 0.0f;
            }
            case INTEGER: 
            case LONG: 
            case SHORT: {
                return a.longValue() == 0L;
            }
            case BIGDECIMAL: {
                return ((BigDecimal)BigDecimal.class.cast(a)).equals(BigDecimal.ZERO);
            }
            case BIGINTEGER: {
                return ((BigInteger)BigInteger.class.cast(a)).equals(BigInteger.ZERO);
            }
        }
        throw new NumberFormatException("Unable to convert " + a.getClass().getSimpleName());
    }

    public static Number not(Number a) {
        return MathUtils.isFalse(a) ? 1 : 0;
    }

    public static Number and(Number a, Number b) {
        return MathUtils.isTrue(a) && MathUtils.isTrue(b) ? 1 : 0;
    }

    public static Number or(Number a, Number b) {
        return MathUtils.isTrue(a) || MathUtils.isTrue(b) ? 1 : 0;
    }

    public static Integer toInteger(Object value) {
        return MathUtils.toInteger(value, null);
    }

    public static Integer toInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)Integer.class.cast(value);
        }
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public static Long toLong(Object value) {
        return MathUtils.toLong(value, null);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Long)Long.class.cast(value);
        }
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public static Short toShort(Object value) {
        return MathUtils.toShort(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)Short.class.cast(value);
        }
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).shortValue();
        }
        return Short.parseShort(value.toString());
    }

    public static Float toFloat(Object value) {
        return MathUtils.toFloat(value, null);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)Float.class.cast(value);
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public static Double toDouble(Object value) {
        return MathUtils.toDouble(value, null);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)Double.class.cast(value);
        }
        if (value instanceof Number) {
            return ((Number)Number.class.cast(value)).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public static enum TYPE {
        NULL,
        DOUBLE,
        FLOAT,
        INTEGER,
        LONG,
        SHORT,
        BIGDECIMAL,
        BIGINTEGER,
        NUMBER,
        UNKNOWN;


        public static TYPE getType(Object obj) {
            if (obj == null) {
                return NULL;
            }
            if (obj instanceof Double) {
                return DOUBLE;
            }
            if (obj instanceof Float) {
                return FLOAT;
            }
            if (obj instanceof Integer) {
                return INTEGER;
            }
            if (obj instanceof Long) {
                return LONG;
            }
            if (obj instanceof Short) {
                return SHORT;
            }
            if (obj instanceof BigDecimal) {
                return BIGDECIMAL;
            }
            if (obj instanceof BigInteger) {
                return BIGINTEGER;
            }
            if (obj instanceof Number) {
                return NUMBER;
            }
            return UNKNOWN;
        }
    }
}

