/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.org.retep.util.string.StringUtils;

public abstract class HttpRequest {
    private static final String FORM_CONTENT_TYPE = " application/x-www-form-urlencoded";
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> parameters;
    private final URL url;
    private boolean returnContentOnError = false;
    private String contentType = " application/x-www-form-urlencoded";

    public static HttpRequest createHttpGet(URL url) {
        return new Get(url);
    }

    public static HttpRequest createHttpPost(URL url) {
        return new Post(url);
    }

    public HttpRequest(URL url) {
        this.url = url;
        this.headers = new LinkedHashMap<String, List<String>>();
        this.parameters = new LinkedHashMap<String, List<String>>();
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isReturnContentOnError() {
        return this.returnContentOnError;
    }

    public void setReturnContentOnError(boolean returnContentOnError) {
        this.returnContentOnError = returnContentOnError;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void addHeader(String name, Object value) {
        this.addMap(this.headers, name, value);
    }

    protected void addHeaders(URLConnection connection) {
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            String name = e.getKey();
            for (String value : e.getValue()) {
                connection.addRequestProperty(name, value);
            }
        }
    }

    public Set<Map.Entry<String, List<String>>> getParameters() {
        return this.parameters.entrySet();
    }

    public boolean containsParameters() {
        return !this.parameters.isEmpty();
    }

    public void setParameter(String name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        this.parameters.put(name, Collections.singletonList(value.toString()));
    }

    public void addParameter(String name, Object value) {
        this.addMap(this.parameters, name, value);
    }

    private void addMap(Map<String, List<String>> map, String name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        List<String> params = map.get(name);
        if (params == null) {
            params = new ArrayList<String>();
            map.put(name, params);
        }
        params.add(value.toString());
    }

    public Collection<String> getParameter(String name) {
        return this.parameters.get(name);
    }

    public Collection<String> removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public String getQueryString() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> e : this.getParameters()) {
            String name = URLEncoder.encode(e.getKey(), "UTF-8");
            for (String value : e.getValue()) {
                sb.append(name).append('=').append(URLEncoder.encode(value, "UTF-8")).append('&');
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public abstract String submit() throws IOException;

    private static class Post
    extends HttpRequest {
        public Post(URL url) {
            super(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String submit() throws IOException {
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(this.getUrl().openConnection());
            this.addHeaders(connection);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setAllowUserInteraction(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-type", this.getContentType());
            try {
                DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                try {
                    os.writeBytes(this.getQueryString());
                    os.flush();
                }
                finally {
                    os.close();
                }
                return StringUtils.readStringBuilder(connection.getInputStream()).toString();
            }
            catch (IOException ioe) {
                if (!this.isReturnContentOnError()) {
                    throw ioe;
                }
                return StringUtils.readStringBuilder(connection.getErrorStream()).toString();
            }
        }
    }

    private static class Get
    extends HttpRequest {
        public Get(URL url) {
            super(url);
        }

        @Override
        public String submit() throws IOException {
            URL url = this.getUrl();
            if (this.containsParameters()) {
                url = new URL(url.toString() + "?" + this.getQueryString());
            }
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
            this.addHeaders(connection);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            try {
                connection.connect();
                return StringUtils.readStringBuilder(connection.getInputStream()).toString();
            }
            catch (IOException ioe) {
                if (!this.isReturnContentOnError()) {
                    throw ioe;
                }
                return StringUtils.readStringBuilder(connection.getErrorStream()).toString();
            }
        }
    }
}

