/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.stats;

import java.util.Collection;
import java.util.LinkedList;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.cluster.ClusteredTime;
import uk.org.retep.util.collections.list.ConcurrentList;
import uk.org.retep.util.collections.stats.Statistic;

@ThreadSafe
public class StatisticCollection<T>
extends ConcurrentList<Statistic<T>> {
    private final int maxEntries;
    private final long maxAge;

    public StatisticCollection(int maxEntries) {
        this(maxEntries, Long.MAX_VALUE);
    }

    public StatisticCollection(long maxAge) {
        this(Integer.MAX_VALUE, maxAge);
    }

    public StatisticCollection(int maxEntries, long maxAge) {
        super(new LinkedList());
        this.maxEntries = Math.max(0, maxEntries);
        this.maxAge = Math.max(1L, maxAge);
    }

    public boolean addValue(T value) {
        return this.add(new Statistic<T>(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean add(Statistic<T> e) {
        this.writeLock().lock();
        try {
            boolean ret = super.add(e);
            if (ret) {
                this.cleanUp();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(Collection<? extends Statistic<T>> c) {
        this.writeLock().lock();
        try {
            try {
                boolean bl = super.addAll(c);
                this.cleanUp();
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUp();
                throw throwable;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(int index, Collection<? extends Statistic<T>> c) {
        this.writeLock().lock();
        try {
            try {
                boolean bl = super.addAll(index, c);
                this.cleanUp();
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUp();
                throw throwable;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public Statistic<T> set(int index, Statistic<T> element) {
        this.writeLock().lock();
        try {
            try {
                Statistic<T> statistic = super.set(index, element);
                this.cleanUp();
                return statistic;
            }
            catch (Throwable throwable) {
                this.cleanUp();
                throw throwable;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private long getAge(Statistic<T> stat) {
        if (stat == null) {
            return 0L;
        }
        return ClusteredTime.currentClusterTimeMillis() - stat.getTimestamp();
    }

    private void cleanUp() {
        while (!this.isEmpty() && this.size() > this.maxEntries | this.getAge((Statistic)((LinkedList)this.list).getFirst()) > this.maxAge) {
            ((LinkedList)this.list).removeFirst();
        }
    }
}

