/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Contract;
import uk.org.retep.annotations.Lock;
import uk.org.retep.annotations.NoInstance;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.Singleton;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.annotation.validator.AbstractCodeAnalyser;
import uk.org.retep.util.javac.JavacUtils;
import uk.org.retep.util.string.StringUtils;

public class AnnotationScanner
extends AbstractCodeAnalyser {
    private final TypeElement java_lang_Object;
    private final TypeElement java_util_concurrent_locks_Lock;
    private final TypeElement uk_org_retep_annotations_Contract;
    private final TypeElement uk_org_retep_annotations_Lock;
    private final TypeElement uk_org_retep_annotations_NotThreadSafe;
    private final TypeElement uk_org_retep_annotations_ReadLock;
    private final TypeElement uk_org_retep_annotations_WriteLock;
    private final TypeElement uk_org_retep_annotations_ThreadSafe;
    private final boolean warnMissingJavadocs;
    private final boolean errorMissingJavadocs;
    private final boolean failHashCodeEquals;

    public AnnotationScanner(JavacUtils javacUtils) {
        super(javacUtils);
        this.java_lang_Object = this.elements.getTypeElement("java.lang.Object");
        this.java_util_concurrent_locks_Lock = this.elements.getTypeElement(java.util.concurrent.locks.Lock.class.getName());
        this.uk_org_retep_annotations_Contract = this.elements.getTypeElement(Contract.class.getName());
        this.uk_org_retep_annotations_Lock = this.elements.getTypeElement(Lock.class.getName());
        this.uk_org_retep_annotations_NotThreadSafe = this.elements.getTypeElement(NotThreadSafe.class.getName());
        this.uk_org_retep_annotations_ReadLock = this.elements.getTypeElement(ReadLock.class.getName());
        this.uk_org_retep_annotations_WriteLock = this.elements.getTypeElement(WriteLock.class.getName());
        this.uk_org_retep_annotations_ThreadSafe = this.elements.getTypeElement(ThreadSafe.class.getName());
        this.failHashCodeEquals = this.getOption("failHashCodeEquals", true);
        this.warnMissingJavadocs = this.getOption("warnMissingJavadocs", false);
        this.errorMissingJavadocs = this.getOption("failMissingJavadocs", false);
    }

    @Override
    protected AbstractCodeAnalyser.MetaData createMetadata() {
        return new Meta();
    }

    @Override
    protected boolean filter(TypeElement element) {
        return !(element instanceof PackageElement);
    }

    protected void testJavadoc(Element element, DocType type) {
        Set<Modifier> modifiers;
        if ((this.warnMissingJavadocs || this.errorMissingJavadocs) && !(modifiers = element.getModifiers()).contains((Object)Modifier.PRIVATE) && StringUtils.isStringEmpty(this.elements.getDocComment(element))) {
            if (this.errorMissingJavadocs) {
                this.error(element, type.getKey(), element.getSimpleName());
            } else {
                this.warn(element, type.getKey(), element.getSimpleName());
            }
        }
    }

    @Override
    protected void scanTypeStart(TypeElement element) {
        Meta meta = (Meta)this.getMetaData();
        meta.classElement = element;
        meta.classType = element.asType();
        Set<Modifier> modifiers = element.getModifiers();
        meta.classFinal = modifiers.contains((Object)Modifier.FINAL);
        meta.classAbstract = modifiers.contains((Object)Modifier.ABSTRACT);
        meta.classNoInstance = element.getAnnotation(NoInstance.class) != null;
        meta.classSingleton = element.getAnnotation(Singleton.class) != null;
        meta.classNotThreadSafe = element.getAnnotation(NotThreadSafe.class) != null;
        boolean bl = meta.classThreadSafe = element.getAnnotation(ThreadSafe.class) != null;
        if (meta.classNoInstance && meta.classSingleton) {
            this.error((Element)element, "noinstance.singleton", new Object[0]);
        }
        if (meta.classNotThreadSafe && meta.classThreadSafe) {
            this.error((Element)element, "concurrency.exclusive", new Object[0]);
        }
        this.testJavadoc(element, DocType.TYPE);
    }

    @Override
    protected void scanTypeEnd(TypeElement element) {
        Meta meta = (Meta)this.getMetaData();
        if (meta.classSingleton) {
            if (!meta.hasInstanceField && !meta.hasInstanceMethod) {
                this.error((Element)element, Singleton.class, "singleton.noinstance", new Object[0]);
            }
            if (!meta.hasStaticAccessor) {
                this.error((Element)element, Singleton.class, "singleton.noaccessor", meta.classType);
            }
            if (meta.hasNonDefaultConstructor) {
                this.error((Element)element, Singleton.class, "constructor.nondefault", new Object[0]);
            }
        }
        if (meta.classNoInstance) {
            if (meta.hasInstanceField || meta.hasInstanceMethod) {
                this.error((Element)element, NoInstance.class, "noinstance.instance", new Object[0]);
            }
            if (meta.hasStaticAccessor) {
                this.error((Element)element, NoInstance.class, "noinstance.accessor", new Object[0]);
            }
            if (!meta.hasPrivateDefaultConstructor) {
                this.error((Element)element, NoInstance.class, "constructor.default.private", new Object[0]);
            }
            if (meta.hasNonDefaultConstructor) {
                this.error((Element)element, NoInstance.class, "constructor.nondefault", new Object[0]);
            }
        }
        if (this.failHashCodeEquals && (meta.hasEquals || meta.hasHashCode) && meta.hasEquals ^ meta.hasHashCode) {
            if (meta.hasEquals) {
                this.error((Element)meta.equals, "required.hashCode", new Object[0]);
            } else {
                this.error((Element)meta.hashCode, "required.equals", new Object[0]);
            }
        }
        if (meta.classNotThreadSafe && (meta.hasLock || meta.hasReadLock || meta.hasWriteLock)) {
            this.error((Element)element, NotThreadSafe.class, "concurrency.nothreadsafe.concurrent", new Object[0]);
        }
        if (meta.classThreadSafe) {
            if (meta.hasLock) {
                this.testConcurrencyContract(meta, Lock.class);
            }
            if (meta.hasReadLock) {
                this.testConcurrencyContract(meta, ReadLock.class);
            }
            if (meta.hasWriteLock) {
                this.testConcurrencyContract(meta, WriteLock.class);
            }
        } else if (meta.hasLock || meta.hasReadLock || meta.hasWriteLock) {
            this.error((Element)element, ThreadSafe.class, "concurrency.threadsafe.not.declared", element.getSimpleName());
        }
        boolean ts = false;
        boolean nts = false;
        for (AnnotationMirror am : this.javacUtils.getSuperTypeAnnotations(meta.classElement)) {
            Element te = am.getAnnotationType().asElement();
            if (this.uk_org_retep_annotations_ThreadSafe.equals(te) && !meta.classThreadSafe) {
                ts = true;
                continue;
            }
            if (!this.uk_org_retep_annotations_NotThreadSafe.equals(te) || meta.classThreadSafe) continue;
            nts = true;
        }
        if (ts && !meta.classThreadSafe) {
            this.error((Element)element, ThreadSafe.class, "concurrency.threadsafe.not.declared", element.getSimpleName());
        }
        if (nts && !meta.classNotThreadSafe) {
            this.error((Element)element, NotThreadSafe.class, "concurrency.nothreadsafe.concurrent", new Object[0]);
        }
    }

    private void testConcurrencyContract(Meta meta, Class clazz) {
        Element re;
        boolean valid;
        String name = StringUtils.lowercase(clazz.getSimpleName());
        ExecutableElement ee = this.javacUtils.getExecutableElement(meta.classElement, this.elements.getName(name), true);
        boolean bl = valid = ee != null;
        if (valid) {
            TypeElement te = this.javacUtils.getTypeElementForExecutableElement(meta.classElement, this.elements.getName(name), true);
            Contract contract = ee.getAnnotation(Contract.class);
            if (contract == null) {
                this.warn((Element)meta.classElement, clazz, "contract.missing.method", te, name, clazz.getName());
            } else {
                ArrayList<? extends TypeMirror> contracts = new ArrayList<TypeMirror>();
                try {
                    contract.value();
                }
                catch (MirroredTypeException mte) {
                    contracts.add(mte.getTypeMirror());
                }
                catch (MirroredTypesException mte) {
                    contracts.addAll(mte.getTypeMirrors());
                }
                boolean found = false;
                String className = clazz.getName();
                for (Object e : contracts) {
                    if (!className.equals(e.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.warn((Element)meta.classElement, clazz, "contract.invalid", te, name, clazz.getName());
                }
            }
        } else {
            this.error((Element)meta.classElement, clazz, "concurrency.threadsafe.contract.method", meta.classElement.getSimpleName(), clazz.getSimpleName(), name);
            return;
        }
        if (valid) {
            Set<Modifier> modifiers = ee.getModifiers();
            boolean bl2 = valid = modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.FINAL) && modifiers.contains((Object)Modifier.PROTECTED);
        }
        if (valid) {
            boolean bl3 = valid = ee.getParameters().isEmpty() && ee.getThrownTypes().isEmpty();
        }
        if (valid && !(valid = this.java_util_concurrent_locks_Lock.equals(re = this.types.asElement(ee.getReturnType())))) {
            System.out.println(meta.classElement + " returnType " + name + " " + this.java_util_concurrent_locks_Lock.hashCode() + " " + ((Object)re).hashCode());
        }
        if (!valid) {
            this.error((Element)meta.classElement, clazz, "concurrency.threadsafe.contract", meta.classElement.getSimpleName(), clazz.getSimpleName());
        }
    }

    @Override
    protected void scanConstructor(ExecutableElement constructor) {
        Meta meta = (Meta)this.getMetaData();
        Set<Modifier> modifiers = constructor.getModifiers();
        boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC);
        boolean isPrivate = modifiers.contains((Object)Modifier.PRIVATE);
        boolean isProtected = modifiers.contains((Object)Modifier.PROTECTED);
        boolean isPackage = !isPublic && !isPrivate && !isProtected;
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        if (constructor.getParameters().isEmpty()) {
            meta.hasDefaultConstructor = true;
            meta.hasPackageDefaultConstructor = isPackage;
            meta.hasPrivateDefaultConstructor = isPrivate;
            meta.hasPublicDefaultConstructor = isPublic;
            if (meta.classNoInstance && !isPrivate) {
                this.error((Element)constructor, NoInstance.class, "noinstance.default.constructor", new Object[0]);
            }
        } else {
            meta.hasNonDefaultConstructor = true;
            meta.hasPackageNonDefaultConstructor = isPackage;
            meta.hasPrivateNonDefaultConstructor = isPrivate;
            meta.hasPublicNonDefaultConstructor = isPublic;
            if (meta.classSingleton) {
                this.error((Element)constructor, Singleton.class, "constructor.nondefault", new Object[0]);
            }
            if (meta.classNoInstance) {
                this.error((Element)constructor, NoInstance.class, "constructor.nondefault", new Object[0]);
            }
        }
        this.testJavadoc(constructor, DocType.CONSTRUCTOR);
    }

    @Override
    protected void scanMethod(ExecutableElement method) {
        Meta meta = (Meta)this.getMetaData();
        Set<Modifier> modifiers = method.getModifiers();
        boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC);
        boolean isPrivate = modifiers.contains((Object)Modifier.PRIVATE);
        boolean isProtected = modifiers.contains((Object)Modifier.PROTECTED);
        boolean isPackage = !isPublic && !isPrivate && !isProtected;
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        if (isStatic) {
            if (isPublic && ((Object)meta.classType).equals(method.getReturnType())) {
                if (method.getParameters().isEmpty()) {
                    meta.hasStaticAccessor = true;
                } else if (meta.classSingleton) {
                    this.error((Element)method, Singleton.class, "singleton.instance.ref.noargs", new Object[0]);
                }
            }
        } else {
            meta.hasInstanceMethod = true;
            meta.hasPublicInstanceMethod |= isPublic;
            if (meta.classNoInstance) {
                this.error((Element)method, NoInstance.class, "noinstance.instance.method", new Object[0]);
            }
        }
        if (isProtected && meta.classNoInstance) {
            this.error((Element)method, NoInstance.class, "protected.useless", new Object[0]);
        }
        String name = method.getSimpleName().toString();
        List<? extends VariableElement> params = method.getParameters();
        if ("hashCode".equals(name) && params.isEmpty()) {
            meta.hasHashCode = true;
            meta.hashCode = method;
        } else if ("equals".equals(name) && params.size() == 1) {
            TypeMirror p0 = params.get(0).asType();
            if (((Object)this.java_lang_Object.asType()).equals(p0)) {
                meta.hasEquals = true;
                meta.equals = method;
            }
        }
        boolean hasLock = method.getAnnotation(Lock.class) != null;
        boolean hasReadLock = method.getAnnotation(ReadLock.class) != null;
        boolean hasWriteLock = method.getAnnotation(WriteLock.class) != null;
        meta.hasLock |= hasLock;
        meta.hasReadLock |= hasReadLock;
        meta.hasWriteLock |= hasWriteLock;
        if (hasLock && (hasReadLock || hasWriteLock) || hasReadLock && hasWriteLock) {
            this.error((Element)method, ThreadSafe.class, "concurrency.lock.exclusive", name);
        }
        for (AnnotationMirror am : this.javacUtils.getAllMethodAnnotations(method)) {
            DeclaredType declaredType = am.getAnnotationType();
            this.testLockOverride(method, declaredType, this.uk_org_retep_annotations_Lock, hasLock, Lock.class, hasReadLock, ReadLock.class, hasWriteLock, WriteLock.class);
            this.testLockOverride(method, declaredType, this.uk_org_retep_annotations_ReadLock, hasReadLock, ReadLock.class, hasLock, Lock.class, hasWriteLock, WriteLock.class);
            this.testLockOverride(method, declaredType, this.uk_org_retep_annotations_WriteLock, hasWriteLock, WriteLock.class, hasLock, Lock.class, hasReadLock, ReadLock.class);
        }
        this.testJavadoc(method, DocType.METHOD);
    }

    private void testLockOverride(ExecutableElement method, DeclaredType declaredType, TypeElement typeElement, boolean matchLock, Class classLock, boolean checkLock1, Class classLock1, boolean checkLock2, Class classLock2) {
        if (this.types.isSameType(declaredType, typeElement.asType())) {
            if (checkLock1) {
                this.error((Element)method, classLock1, "concurrency.lock.incompatible", method.getSimpleName(), classLock.getSimpleName(), classLock1.getSimpleName());
            }
            if (checkLock2) {
                this.error((Element)method, classLock2, "concurrency.lock.incompatible", method.getSimpleName(), classLock.getSimpleName(), classLock2.getSimpleName());
            } else if (!matchLock) {
                this.warn((Element)method, classLock, "concurrency.lock.override", method.getSimpleName(), classLock.getSimpleName());
            }
        }
    }

    @Override
    protected void scanField(VariableElement var) {
        Meta meta = (Meta)this.getMetaData();
        Set<Modifier> modifiers = var.getModifiers();
        boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC);
        boolean isPrivate = modifiers.contains((Object)Modifier.PRIVATE);
        boolean isProtected = modifiers.contains((Object)Modifier.PROTECTED);
        boolean isPackage = !isPublic && !isPrivate && !isProtected;
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        boolean isFinal = modifiers.contains((Object)Modifier.FINAL);
        if (!isStatic) {
            meta.hasInstanceField = true;
            meta.hasPublicInstanceField |= isPublic;
            if (meta.classNoInstance) {
                this.error((Element)var, NoInstance.class, "noinstance.instance.field", new Object[0]);
            }
        }
        if (isProtected) {
            if (meta.classSingleton) {
                this.error((Element)var, Singleton.class, "protected.useless", new Object[0]);
            } else if (meta.classNoInstance) {
                this.error((Element)var, NoInstance.class, "protected.useless", new Object[0]);
            }
        }
        if (((Object)meta.classType).equals(var.asType())) {
            if (meta.classNoInstance) {
                this.error((Element)var, NoInstance.class, "noinstance.instance.ref", new Object[0]);
            }
            if (meta.classSingleton) {
                if (!isStatic) {
                    this.error((Element)var, Singleton.class, "singleton.instance.ref.nonstatic", new Object[0]);
                }
                if (!isPrivate) {
                    this.error((Element)var, Singleton.class, "singleton.instance.ref.nonprivate", new Object[0]);
                }
            }
        }
        this.testJavadoc(var, isStatic && isFinal ? DocType.CONSTANT : DocType.FIELD);
    }

    private static class Meta
    extends AbstractCodeAnalyser.MetaData {
        TypeElement classElement;
        TypeMirror classType;
        boolean classFinal;
        boolean classAbstract;
        boolean classSingleton;
        boolean classNoInstance;
        boolean classThreadSafe;
        boolean classNotThreadSafe;
        boolean hasDefaultConstructor;
        boolean hasPackageDefaultConstructor;
        boolean hasPublicDefaultConstructor;
        boolean hasPrivateDefaultConstructor;
        boolean hasNonDefaultConstructor;
        boolean hasPackageNonDefaultConstructor;
        boolean hasPublicNonDefaultConstructor;
        boolean hasPrivateNonDefaultConstructor;
        boolean hasStaticAccessor;
        boolean hasInstanceField;
        boolean hasPublicInstanceField;
        boolean hasInstanceMethod;
        boolean hasPublicInstanceMethod;
        boolean hasHashCode;
        ExecutableElement hashCode;
        boolean hasEquals;
        ExecutableElement equals;
        boolean hasLock;
        boolean hasReadLock;
        boolean hasWriteLock;

        private Meta() {
        }
    }

    protected static enum DocType {
        CONSTANT("javadoc.missing.constant"),
        CONSTRUCTOR("javadoc.missing.constructor"),
        FIELD("javadoc.missing.field"),
        METHOD("javadoc.missing.method"),
        TYPE("javadoc.missing.type");

        private final String key;

        private DocType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

