/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapWrapper
implements Map<String, Node> {
    private final NamedNodeMap map;

    public NamedNodeMapWrapper(NamedNodeMap map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.getLength();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Node) {
            Node node = (Node)value;
            return this.map.getNamedItem(node.getNodeName()) != null;
        }
        return false;
    }

    @Override
    public Node get(Object key) {
        return this.map.getNamedItem(String.valueOf(key));
    }

    @Override
    public Node put(String key, Node value) {
        this.map.setNamedItem(value);
        return null;
    }

    @Override
    public Node remove(Object key) {
        return this.map.removeNamedItem(String.valueOf(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends Node> m) {
        for (Node node : m.values()) {
            this.map.setNamedItem(node);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            set.add(this.map.item(i).getNodeName());
        }
        return set;
    }

    @Override
    public Collection<Node> values() {
        ArrayList<Node> list = new ArrayList<Node>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.map.item(i));
        }
        return list;
    }

    @Override
    public Set<Map.Entry<String, Node>> entrySet() {
        HashSet<Map.Entry<String, Node>> set = new HashSet<Map.Entry<String, Node>>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            final Node node = this.map.item(i);
            set.add(new Map.Entry<String, Node>(){

                @Override
                public String getKey() {
                    return node.getNodeName();
                }

                @Override
                public Node getValue() {
                    return node;
                }

                @Override
                public Node setValue(Node value) {
                    throw new UnsupportedOperationException("Not supported");
                }
            });
        }
        return set;
    }
}

