/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.monitor;

import java.awt.EventQueue;
import javax.swing.JProgressBar;
import uk.org.retep.annotations.DispatchThread;
import uk.org.retep.annotations.InvocationType;
import uk.org.retep.util.monitor.ProgressListener;

public class JProgressBarListener
implements ProgressListener {
    private final JProgressBar component;
    private final JProgressBar secondaryComponent;

    public JProgressBarListener(JProgressBar component) {
        this(component, null);
    }

    public JProgressBarListener(JProgressBar component, JProgressBar secondaryComponent) {
        if (component == null && secondaryComponent == null) {
            throw new IllegalArgumentException("Both components may not be null");
        }
        this.component = component;
        this.secondaryComponent = secondaryComponent;
        if (component != null) {
            component.setIndeterminate(true);
        }
        if (secondaryComponent != null) {
            secondaryComponent.setIndeterminate(true);
        }
    }

    public JProgressBar getComponent() {
        return this.component;
    }

    public JProgressBar getSecondaryComponent() {
        return this.secondaryComponent;
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    public void showProgress(int progress) {
        EventQueue.invokeLater(new 0r(progress));
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_LATER)
    public void showProgress(long inputSize, long outputSize) {
        EventQueue.invokeLater(new 1r(inputSize, outputSize));
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_IMMEDIATE)
    public void setMaximum(long maximum) {
        if (EventQueue.isDispatchThread()) {
            this.setMaximum$2(maximum);
        } else {
            EventQueue.invokeLater(new 2r(maximum));
        }
    }

    @Override
    @DispatchThread(invocationType=InvocationType.INVOKE_IMMEDIATE)
    public void setMaximum(long inputMaximum, long outputMaximum) {
        if (EventQueue.isDispatchThread()) {
            this.setMaximum$3(inputMaximum, outputMaximum);
        } else {
            EventQueue.invokeLater(new 3r(inputMaximum, outputMaximum));
        }
    }

    private void showProgress$0(int progress) {
        if (this.component != null) {
            this.component.setValue(progress);
            this.component.setIndeterminate(false);
            this.component.repaint();
        }
    }

    private void showProgress$1(long inputSize, long outputSize) {
        if (this.component != null) {
            this.component.setValue((int)inputSize);
            this.component.setIndeterminate(false);
            this.component.repaint();
        }
        if (this.secondaryComponent != null) {
            this.secondaryComponent.setValue((int)outputSize);
            this.secondaryComponent.setIndeterminate(false);
            this.secondaryComponent.repaint();
        }
    }

    private void setMaximum$2(long maximum) {
        this.component.setMaximum((int)maximum);
    }

    private void setMaximum$3(long inputMaximum, long outputMaximum) {
        if (this.component != null) {
            this.component.setMaximum((int)inputMaximum);
        }
        if (this.secondaryComponent != null) {
            this.secondaryComponent.setMaximum((int)outputMaximum);
        }
    }

    class 0r
    implements Runnable {
        private final int progress;

        0r(int x1) {
            this.progress = x1;
        }

        @Override
        public void run() {
            JProgressBarListener.this.showProgress$0(this.progress);
        }
    }

    class 1r
    implements Runnable {
        private final long inputSize;
        private final long outputSize;

        1r(long x1, long x2) {
            this.inputSize = x1;
            this.outputSize = x2;
        }

        @Override
        public void run() {
            JProgressBarListener.this.showProgress$1(this.inputSize, this.outputSize);
        }
    }

    class 2r
    implements Runnable {
        private final long maximum;

        2r(long x1) {
            this.maximum = x1;
        }

        @Override
        public void run() {
            JProgressBarListener.this.setMaximum$2(this.maximum);
        }
    }

    class 3r
    implements Runnable {
        private final long inputMaximum;
        private final long outputMaximum;

        3r(long x1, long x2) {
            this.inputMaximum = x1;
            this.outputMaximum = x2;
        }

        @Override
        public void run() {
            JProgressBarListener.this.setMaximum$3(this.inputMaximum, this.outputMaximum);
        }
    }
}

