/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.util.UUID;

public final class BitUtils {
    private BitUtils() {
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar(byte[] b, int off) {
        return (char)(((b[off + 1] & 0xFF) << 0) + (b[off + 0] << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + (b[off + 0] << 8));
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off + 0] << 24);
    }

    public static int getInt3(byte[] b, int off) {
        return ((b[off + 2] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 0] & 0xFF) << 16);
    }

    public static float getFloat(byte[] b, int off) {
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off + 0] << 24);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off + 0] << 56);
    }

    public static double getDouble(byte[] b, int off) {
        long j = (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off + 0] << 56);
        return Double.longBitsToDouble(j);
    }

    public static UUID getUUID(byte[] b, int off) {
        return new UUID(BitUtils.getLong(b, off), BitUtils.getLong(b, off + 8));
    }

    public static void setBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
    }

    public static void setChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void setShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void setInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
    }

    public static void setInt3(byte[] b, int off, int val) {
        b[off + 2] = (byte)(val >>> 0);
        b[off + 1] = (byte)(val >>> 8);
        b[off + 0] = (byte)(val >>> 16);
    }

    public static void setFloat(byte[] b, int off, float val) {
        int i = Float.floatToIntBits(val);
        b[off + 3] = (byte)(i >>> 0);
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
    }

    public static void setLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }

    public static void setDouble(byte[] b, int off, double val) {
        long j = Double.doubleToLongBits(val);
        b[off + 7] = (byte)(j >>> 0);
        b[off + 6] = (byte)(j >>> 8);
        b[off + 5] = (byte)(j >>> 16);
        b[off + 4] = (byte)(j >>> 24);
        b[off + 3] = (byte)(j >>> 32);
        b[off + 2] = (byte)(j >>> 40);
        b[off + 1] = (byte)(j >>> 48);
        b[off + 0] = (byte)(j >>> 56);
    }

    public static void setUUID(byte[] b, int off, UUID val) {
        BitUtils.setLong(b, off, val.getMostSignificantBits());
        BitUtils.setLong(b, off + 8, val.getLeastSignificantBits());
    }
}

