/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.org.retep.util.io.lzma.Base;
import uk.org.retep.util.io.lzma.BitTreeDecoder;
import uk.org.retep.util.io.lzma.OutWindow;
import uk.org.retep.util.io.lzma.RangeDecoder;

public class Decoder {
    private OutWindow m_OutWindow = new OutWindow();
    private RangeDecoder m_RangeDecoder = new RangeDecoder();
    private short[] m_IsMatchDecoders = new short[192];
    private short[] m_IsRepDecoders = new short[12];
    private short[] m_IsRepG0Decoders = new short[12];
    private short[] m_IsRepG1Decoders = new short[12];
    private short[] m_IsRepG2Decoders = new short[12];
    private short[] m_IsRep0LongDecoders = new short[192];
    private BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    private short[] m_PosDecoders = new short[114];
    private BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    private LenDecoder m_LenDecoder = new LenDecoder();
    private LenDecoder m_RepLenDecoder = new LenDecoder();
    private LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    private int m_DictionarySize = -1;
    private int m_DictionarySizeCheck = -1;
    private int m_PosStateMask;

    public Decoder() {
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    private boolean setDictionarySize(int dictionarySize) {
        if (dictionarySize < 0) {
            return false;
        }
        if (this.m_DictionarySize != dictionarySize) {
            this.m_DictionarySize = dictionarySize;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.create(Math.max(this.m_DictionarySizeCheck, 4096));
        }
        return true;
    }

    private boolean setLcLpPb(int lc, int lp, int pb) {
        if (lc > 8 || lp > 4 || pb > 4) {
            return false;
        }
        this.m_LiteralDecoder.create(lp, lc);
        int numPosStates = 1 << pb;
        this.m_LenDecoder.Create(numPosStates);
        this.m_RepLenDecoder.Create(numPosStates);
        this.m_PosStateMask = numPosStates - 1;
        return true;
    }

    private void init() throws IOException {
        this.m_OutWindow.init(false);
        RangeDecoder.initBitModels(this.m_IsMatchDecoders);
        RangeDecoder.initBitModels(this.m_IsRep0LongDecoders);
        RangeDecoder.initBitModels(this.m_IsRepDecoders);
        RangeDecoder.initBitModels(this.m_IsRepG0Decoders);
        RangeDecoder.initBitModels(this.m_IsRepG1Decoders);
        RangeDecoder.initBitModels(this.m_IsRepG2Decoders);
        RangeDecoder.initBitModels(this.m_PosDecoders);
        this.m_LiteralDecoder.init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].init();
        }
        this.m_LenDecoder.init();
        this.m_RepLenDecoder.init();
        this.m_PosAlignDecoder.init();
        this.m_RangeDecoder.init();
    }

    public boolean code(InputStream inStream, OutputStream outStream, long outSize) throws IOException {
        this.m_RangeDecoder.setStream(inStream);
        this.m_OutWindow.setStream(outStream);
        this.init();
        int state = Base.stateInit();
        int rep0 = 0;
        int rep1 = 0;
        int rep2 = 0;
        int rep3 = 0;
        long nowPos64 = 0L;
        byte prevByte = 0;
        while (outSize < 0L || nowPos64 < outSize) {
            int len;
            int posState = (int)nowPos64 & this.m_PosStateMask;
            if (this.m_RangeDecoder.decodeBit(this.m_IsMatchDecoders, (state << 4) + posState) == 0) {
                LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.getDecoder((int)nowPos64, prevByte);
                prevByte = !Base.stateIsCharState(state) ? decoder2.decodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.getByte(rep0)) : decoder2.decodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.putByte(prevByte);
                state = Base.stateUpdateChar(state);
                ++nowPos64;
                continue;
            }
            if (this.m_RangeDecoder.decodeBit(this.m_IsRepDecoders, state) == 1) {
                len = 0;
                if (this.m_RangeDecoder.decodeBit(this.m_IsRepG0Decoders, state) == 0) {
                    if (this.m_RangeDecoder.decodeBit(this.m_IsRep0LongDecoders, (state << 4) + posState) == 0) {
                        state = Base.stateUpdateShortRep(state);
                        len = 1;
                    }
                } else {
                    int distance;
                    if (this.m_RangeDecoder.decodeBit(this.m_IsRepG1Decoders, state) == 0) {
                        distance = rep1;
                    } else {
                        if (this.m_RangeDecoder.decodeBit(this.m_IsRepG2Decoders, state) == 0) {
                            distance = rep2;
                        } else {
                            distance = rep3;
                            rep3 = rep2;
                        }
                        rep2 = rep1;
                    }
                    rep1 = rep0;
                    rep0 = distance;
                }
                if (len == 0) {
                    len = this.m_RepLenDecoder.decode(this.m_RangeDecoder, posState) + 2;
                    state = Base.stateUpdateRep(state);
                }
            } else {
                rep3 = rep2;
                rep2 = rep1;
                rep1 = rep0;
                len = 2 + this.m_LenDecoder.decode(this.m_RangeDecoder, posState);
                state = Base.stateUpdateMatch(state);
                int posSlot = this.m_PosSlotDecoder[Base.GetLenToPosState(len)].decode(this.m_RangeDecoder);
                if (posSlot >= 4) {
                    int numDirectBits = (posSlot >> 1) - 1;
                    rep0 = (2 | posSlot & 1) << numDirectBits;
                    if (posSlot < 14) {
                        rep0 += BitTreeDecoder.reverseDecode(this.m_PosDecoders, rep0 - posSlot - 1, this.m_RangeDecoder, numDirectBits);
                    } else {
                        rep0 += this.m_RangeDecoder.decodeDirectBits(numDirectBits - 4) << 4;
                        if ((rep0 += this.m_PosAlignDecoder.reverseDecode(this.m_RangeDecoder)) < 0) {
                            if (rep0 == -1) break;
                            return false;
                        }
                    }
                } else {
                    rep0 = posSlot;
                }
            }
            if ((long)rep0 >= nowPos64 || rep0 >= this.m_DictionarySizeCheck) {
                return false;
            }
            this.m_OutWindow.copyBlock(rep0, len);
            nowPos64 += (long)len;
            prevByte = this.m_OutWindow.getByte(0);
        }
        this.m_OutWindow.flush();
        this.m_OutWindow.releaseStream();
        this.m_RangeDecoder.releaseStream();
        return true;
    }

    public boolean setDecoderProperties(byte[] properties) {
        if (properties.length < 5) {
            return false;
        }
        int val = properties[0] & 0xFF;
        int lc = val % 9;
        int remainder = val / 9;
        int lp = remainder % 5;
        int pb = remainder / 5;
        int dictionarySize = 0;
        for (int i = 0; i < 4; ++i) {
            dictionarySize += (properties[1 + i] & 0xFF) << i * 8;
        }
        if (!this.setLcLpPb(lc, lp, pb)) {
            return false;
        }
        return this.setDictionarySize(dictionarySize);
    }

    private class LiteralDecoder {
        private Decoder2[] m_Coders;
        private int m_NumPrevBits;
        private int m_NumPosBits;
        private int m_PosMask;

        private LiteralDecoder() {
        }

        public void create(int numPosBits, int numPrevBits) {
            if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
                return;
            }
            this.m_NumPosBits = numPosBits;
            this.m_PosMask = (1 << numPosBits) - 1;
            this.m_NumPrevBits = numPrevBits;
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[numStates];
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i] = new Decoder2();
            }
        }

        public void init() {
            int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < numStates; ++i) {
                this.m_Coders[i].init();
            }
        }

        private Decoder2 getDecoder(int pos, byte prevByte) {
            return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + ((prevByte & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        private class Decoder2 {
            private short[] m_Decoders = new short[768];

            private Decoder2() {
            }

            public void init() {
                RangeDecoder.initBitModels(this.m_Decoders);
            }

            public byte decodeNormal(RangeDecoder rangeDecoder) throws IOException {
                int symbol = 1;
                while ((symbol = symbol << 1 | rangeDecoder.decodeBit(this.m_Decoders, symbol)) < 256) {
                }
                return (byte)symbol;
            }

            public byte decodeWithMatchByte(RangeDecoder rangeDecoder, byte matchByte) throws IOException {
                int b = matchByte;
                int symbol = 1;
                do {
                    int matchBit = b >> 7 & 1;
                    b <<= 1;
                    int bit = rangeDecoder.decodeBit(this.m_Decoders, (1 + matchBit << 8) + symbol);
                    symbol = symbol << 1 | bit;
                    if (matchBit == bit) continue;
                    while (symbol < 256) {
                        symbol = symbol << 1 | rangeDecoder.decodeBit(this.m_Decoders, symbol);
                    }
                    break;
                } while (symbol < 256);
                return (byte)symbol;
            }
        }
    }

    private class LenDecoder {
        private short[] m_Choice = new short[2];
        private BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        private BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        private BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
        private int m_NumPosStates = 0;

        private LenDecoder() {
        }

        public void Create(int numPosStates) {
            while (this.m_NumPosStates < numPosStates) {
                this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                ++this.m_NumPosStates;
            }
        }

        public void init() {
            RangeDecoder.initBitModels(this.m_Choice);
            for (int posState = 0; posState < this.m_NumPosStates; ++posState) {
                this.m_LowCoder[posState].init();
                this.m_MidCoder[posState].init();
            }
            this.m_HighCoder.init();
        }

        public int decode(RangeDecoder rangeDecoder, int posState) throws IOException {
            if (rangeDecoder.decodeBit(this.m_Choice, 0) == 0) {
                return this.m_LowCoder[posState].decode(rangeDecoder);
            }
            int symbol = 8;
            symbol = rangeDecoder.decodeBit(this.m_Choice, 1) == 0 ? (symbol += this.m_MidCoder[posState].decode(rangeDecoder)) : (symbol += 8 + this.m_HighCoder.decode(rangeDecoder));
            return symbol;
        }
    }
}

