/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.collections.set.ConcurrentSet;
import uk.org.retep.util.concurrent.ReadWriteConcurrencySupport;

@ThreadSafe
public class ConcurrentSetWrapper<E>
extends ReadWriteConcurrencySupport
implements Set<E>,
ConcurrentSet<E>,
Serializable {
    private static final long serialVersionUID = -1424769029926980924L;
    private final Set<E> set;

    public ConcurrentSetWrapper(Set<E> set) {
        this.set = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int size() {
        this.readLock().lock();
        try {
            int n = this.set.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean isEmpty() {
        this.readLock().lock();
        try {
            boolean bl = this.set.isEmpty();
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean contains(Object o) {
        this.readLock().lock();
        try {
            boolean bl = this.set.contains(o);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Iterator<E> iterator() {
        this.readLock().lock();
        try {
            final Iterator<E> it = this.set.iterator();
            Iterator iterator = new Iterator<E>(){

                @Override
                @ReadLock
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                @ReadLock
                public E next() {
                    return it.next();
                }

                @Override
                @WriteLock
                public void remove() {
                    it.remove();
                }
            };
            return iterator;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Object[] toArray() {
        this.readLock().lock();
        try {
            Object[] objectArray = this.set.toArray();
            return objectArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public <T> T[] toArray(T[] a) {
        this.readLock().lock();
        try {
            T[] TArray = this.set.toArray(a);
            return TArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean add(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.set.add(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean remove(Object o) {
        this.writeLock().lock();
        try {
            boolean bl = this.set.remove(o);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean containsAll(Collection<?> c) {
        this.readLock().lock();
        try {
            boolean bl = this.set.containsAll(c);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean addAll(Collection<? extends E> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.set.addAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean retainAll(Collection<?> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.set.retainAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public boolean removeAll(Collection<?> c) {
        this.writeLock().lock();
        try {
            boolean bl = this.set.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void clear() {
        this.writeLock().lock();
        try {
            this.set.clear();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @WriteLock
    public boolean addIfAbsent(E e) {
        this.writeLock().lock();
        try {
            boolean bl = this.add(e);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

