/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.state;

import java.util.HashMap;
import java.util.Map;
import uk.org.retep.util.state.InvalidStateChangeException;
import uk.org.retep.util.state.UnknownStateException;

public class StateEngine<T> {
    private Map<T, T[]> validStateMap = new HashMap<T, T[]>();
    private Map<T, Map<T, T[]>> sequenceMap = new HashMap<T, Map<T, T[]>>();
    private String stateName;

    private String getStateName() {
        return this.stateName == null ? "Unknown" : this.stateName;
    }

    public void setStateChange(T state, T ... validStates) {
        this.validStateMap.put(state, validStates);
        if (this.stateName == null) {
            this.stateName = state.getClass().getSimpleName();
        }
    }

    public T getNextState(T state) throws UnknownStateException {
        T[] validStateChanges = this.getValidStates(state);
        if (validStateChanges.length == 0) {
            return null;
        }
        return validStateChanges[0];
    }

    public void setStateSequence(T from, T to, T ... sequence) throws UnknownStateException {
        this.assertState(from);
        this.assertState(to);
        for (T t : sequence) {
            this.assertState(t);
        }
        Map<T, T[]> map = this.sequenceMap.get(from);
        if (map == null) {
            map = new HashMap<T, T[]>();
            this.sequenceMap.put(from, map);
        }
        map.put(to, sequence);
    }

    public T[] getStateChangeSequence(T from, T to) throws UnknownStateException, InvalidStateChangeException {
        this.assertState(from);
        this.assertState(to);
        T[] sequence = null;
        Map<T, T[]> map = this.sequenceMap.get(from);
        if (map == null) {
            throw new InvalidStateChangeException(from, to);
        }
        sequence = map.get(to);
        if (sequence == null) {
            throw new InvalidStateChangeException(from, to);
        }
        return sequence;
    }

    public T[] getValidStates(T state) throws UnknownStateException {
        T[] validStates = this.validStateMap.get(state);
        if (validStates == null) {
            throw new UnknownStateException(state);
        }
        return validStates;
    }

    public boolean isStateChangeValid(T oldState, T newState) throws UnknownStateException {
        if (oldState == null) {
            throw new NullPointerException("Provided old state is null");
        }
        if (newState == null) {
            throw new NullPointerException("Provided new state is null");
        }
        for (T state : this.getValidStates(oldState)) {
            if (!newState.equals(state)) continue;
            return true;
        }
        return false;
    }

    public void assertStateChange(T oldState, T newState) throws InvalidStateChangeException, UnknownStateException {
        if (!this.isStateChangeValid(oldState, newState)) {
            throw new InvalidStateChangeException(oldState, newState);
        }
    }

    public void assertState(T state) throws UnknownStateException {
        if (!this.validStateMap.containsKey(state)) {
            throw new UnknownStateException(state);
        }
    }
}

