/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;
import uk.org.retep.util.reference.CleanableWeakReference;
import uk.org.retep.util.thread.DelayedRunnableThreadPoolExecutor;
import uk.org.retep.util.thread.GlobalThreadPool;

@ThreadSafe
public final class ReferenceFactory {
    private static final Log log = LogFactory.getLog(ReferenceFactory.class);
    private static DelayedRunnableThreadPoolExecutor delayPool;
    private static CleanableReferenceQueue referenceQueue;
    private static ThreadFactory threadFactory;

    private ReferenceFactory() {
    }

    static synchronized ThreadFactory getThreadFactory() {
        if (threadFactory == null) {
            threadFactory = GlobalThreadPool.createDaemonThreadFactory("ReferenceFactory");
        }
        return threadFactory;
    }

    public static synchronized DelayedRunnableThreadPoolExecutor getDelayThreadPoolExecutor() {
        if (delayPool == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating DelayedRunnableThreadPoolExecutor");
            }
            delayPool = new DelayedRunnableThreadPoolExecutor(1, 10, 5L, TimeUnit.MINUTES, ReferenceFactory.getThreadFactory());
            delayPool.prestartCoreThread();
        }
        return delayPool;
    }

    public static synchronized ReferenceQueue<Object> getReferenceQueue() {
        if (referenceQueue == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating ReferenceQueue");
            }
            referenceQueue = new CleanableReferenceQueue();
            ReferenceFactory.getThreadFactory().newThread(referenceQueue).start();
        }
        return referenceQueue;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    private static final class CleanableReferenceQueue
    extends ReferenceQueue<Object>
    implements Runnable {
        private CleanableReferenceQueue() {
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (ReferenceFactory.access$100().isDebugEnabled()) {
                ReferenceFactory.access$100().debug("starting ReferenceQueue");
            }
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        ref = super.remove(0L);
                        if (ReferenceFactory.access$100().isDebugEnabled()) {
                            ReferenceFactory.access$100().debug("dequeued reference %s", new Object[]{ref.toString()});
                        }
                        if (!(ref instanceof CleanableWeakReference)) {
                            ReferenceFactory.access$100().warn("A reference not a subclass of CleanableWeakReference has been added to the Utilities.activeReferenceQueue(): %s", new Object[]{ref.getClass()});
                            continue;
                        }
                        try {
                            ((CleanableWeakReference)ref).cleanupReference();
                        }
                        catch (ThreadDeath td) {
                            if (ReferenceFactory.access$100().isDebugEnabled()) {
                                ReferenceFactory.access$100().debug((Object)"ReferenceQueue ThreadDeath", td);
                            }
                            throw td;
                        }
                        catch (Throwable t) {
                            ReferenceFactory.access$100().fatal((Object)"Throwable that should not happen has happened, please repoort it as a bug", t);
                        }
                        finally {
                            ref = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    if (!ReferenceFactory.access$100().isDebugEnabled()) continue;
                    ReferenceFactory.access$100().debug((Object)"ReferenceQueue InterruptedException", ex);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

