/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.OutputStream;

class RangeEncoder {
    private static final int kTopMask = -16777216;
    private static final int kNumBitModelTotalBits = 11;
    private static final int kBitModelTotal = 2048;
    private static final int kNumMoveBits = 5;
    private OutputStream stream;
    private long low;
    private int range;
    private int cacheSize;
    private int cache;
    private long position;
    private static final int kNumMoveReducingBits = 2;
    public static final int kNumBitPriceShiftBits = 6;
    private static int[] probPrices = new int[512];

    RangeEncoder() {
    }

    public void setStream(OutputStream stream) {
        this.stream = stream;
    }

    public void releaseStream() {
        this.stream = null;
    }

    public void init() {
        this.position = 0L;
        this.low = 0L;
        this.range = -1;
        this.cacheSize = 1;
        this.cache = 0;
    }

    public void flushData() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.shiftLow();
        }
    }

    public void flushStream() throws IOException {
        this.stream.flush();
    }

    public void shiftLow() throws IOException {
        int LowHi = (int)(this.low >>> 32);
        if (LowHi != 0 || this.low < 0xFF000000L) {
            this.position += (long)this.cacheSize;
            int temp = this.cache;
            do {
                this.stream.write(temp + LowHi);
                temp = 255;
            } while (--this.cacheSize != 0);
            this.cache = (int)this.low >>> 24;
        }
        ++this.cacheSize;
        this.low = (this.low & 0xFFFFFFL) << 8;
    }

    public void encodeDirectBits(int v, int numTotalBits) throws IOException {
        for (int i = numTotalBits - 1; i >= 0; --i) {
            this.range >>>= 1;
            if ((v >>> i & 1) == 1) {
                this.low += (long)this.range;
            }
            if ((this.range & 0xFF000000) != 0) continue;
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public long getProcessedSizeAdd() {
        return (long)this.cacheSize + this.position + 4L;
    }

    public static void initBitModels(short[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 1024;
        }
    }

    public void encode(short[] probs, int index, int symbol) throws IOException {
        short prob = probs[index];
        int newBound = (this.range >>> 11) * prob;
        if (symbol == 0) {
            this.range = newBound;
            probs[index] = (short)(prob + (2048 - prob >>> 5));
        } else {
            this.low += (long)newBound & 0xFFFFFFFFL;
            this.range -= newBound;
            probs[index] = (short)(prob - (prob >>> 5));
        }
        if ((this.range & 0xFF000000) == 0) {
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public static int getPrice(int prob, int symbol) {
        return probPrices[((prob - symbol ^ -symbol) & 0x7FF) >>> 2];
    }

    public static int getPrice0(int prob) {
        return probPrices[prob >>> 2];
    }

    public static int getPrice1(int prob) {
        return probPrices[2048 - prob >>> 2];
    }

    static {
        int kNumBits = 9;
        for (int i = kNumBits - 1; i >= 0; --i) {
            int start = 1 << kNumBits - i - 1;
            int end = 1 << kNumBits - i;
            for (int j = start; j < end; ++j) {
                RangeEncoder.probPrices[j] = (i << 6) + (end - j << 6 >>> kNumBits - i - 1);
            }
        }
    }
}

