/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import uk.org.retep.util.io.lzma.Decoder;
import uk.org.retep.util.monitor.ProgressListener;
import uk.org.retep.util.thread.ExecutorFactory;

public class LzmaInputStream
extends InputStream {
    private static final int PROPERTIES_SIZE = 5;
    private final InputStream inputStream;
    private final PipedInputStream pipeIn;
    private final PipedOutputStream pipeOut;
    private ProgressListener listener;
    private Decoder decoder;
    private long outSize;

    public LzmaInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public LzmaInputStream(final InputStream inputStream, ProgressListener listener) throws IOException {
        this.inputStream = inputStream;
        this.listener = listener;
        this.pipeIn = new PipedInputStream();
        this.pipeOut = new PipedOutputStream(this.pipeIn);
        byte[] properties = new byte[5];
        if (inputStream.read(properties) != 5) {
            throw new IOException("Header missing");
        }
        this.decoder = new Decoder();
        if (!this.decoder.setDecoderProperties(properties)) {
            throw new IOException("Invalid stream properties");
        }
        for (int i = 0; i < 8; ++i) {
            int v = inputStream.read();
            if (v < 0) {
                throw new IOException("Can't read stream size");
            }
            this.outSize |= (long)v << 8 * i;
        }
        if (listener != null) {
            listener.setMaximum(this.outSize, this.outSize);
        }
        ExecutorFactory.globalInvokeLater(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    if (LzmaInputStream.this.decoder.code(inputStream, LzmaInputStream.this.pipeOut, LzmaInputStream.this.outSize)) {
                        // empty if block
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    LzmaInputStream.this.pipeOut.flush();
                    LzmaInputStream.this.pipeOut.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.pipeIn.close();
            this.pipeOut.close();
        }
        finally {
            this.inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        return this.pipeIn.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.pipeIn.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.pipeIn.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.pipeIn.skip(n);
    }
}

