/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExternUtils {
    private ExternUtils() {
    }

    public static void writeUTF(ObjectOutput out, String s) throws IOException {
        out.writeBoolean(s != null);
        if (s != null) {
            out.writeUTF(s);
        }
    }

    public static String readUTF(ObjectInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeExternal(ObjectOutput out, Externalizable ext) throws IOException {
        out.writeBoolean(ext != null);
        if (ext != null) {
            ext.writeExternal(out);
        }
    }

    public static <T extends Externalizable> T readExternal(ObjectInput in, Class<T> clazz) throws IOException {
        if (in.readBoolean()) {
            try {
                Externalizable obj = (Externalizable)clazz.newInstance();
                obj.readExternal(in);
                return (T)obj;
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
            catch (InstantiationException ex) {
                throw new IOException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
        return null;
    }

    public static void writeArray(ObjectOutput out, String[] ary) throws IOException {
        out.writeInt(ary == null ? -1 : ary.length);
        if (ary != null) {
            for (String val : ary) {
                ExternUtils.writeUTF(out, val);
            }
        }
    }

    public static String[] readStringArray(ObjectInput in) throws IOException {
        String[] a = null;
        int n = in.readInt();
        if (n > -1) {
            a = new String[n];
            for (int i = 0; i < n; ++i) {
                a[i] = ExternUtils.readUTF(in);
            }
        }
        return a;
    }

    public static void writeArray(ObjectOutput out, int[] ary) throws IOException {
        out.writeInt(ary == null ? -1 : ary.length);
        if (ary != null) {
            for (int v : ary) {
                out.writeDouble(v);
            }
        }
    }

    public static int[] readIntArray(ObjectInput in) throws IOException {
        int[] a = null;
        int n = in.readInt();
        if (n > -1) {
            a = new int[n];
            for (int i = 0; i < n; ++i) {
                a[i] = in.readInt();
            }
        }
        return a;
    }

    public static void writeArray(ObjectOutput out, double[] ary) throws IOException {
        out.writeInt(ary == null ? -1 : ary.length);
        if (ary != null) {
            for (double v : ary) {
                out.writeDouble(v);
            }
        }
    }

    public static double[] readDoubleArray(ObjectInput in) throws IOException {
        double[] a = null;
        int n = in.readInt();
        if (n > -1) {
            a = new double[n];
            for (int i = 0; i < n; ++i) {
                a[i] = in.readDouble();
            }
        }
        return a;
    }

    public static void writeArray(ObjectOutput out, boolean[] ary) throws IOException {
        out.writeInt(ary == null ? -1 : ary.length);
        if (ary != null) {
            for (boolean v : ary) {
                out.writeBoolean(v);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput in) throws IOException {
        boolean[] a = null;
        int n = in.readInt();
        if (n > -1) {
            a = new boolean[n];
            for (int i = 0; i < n; ++i) {
                a[i] = in.readBoolean();
            }
        }
        return a;
    }

    public static void writeStringMap(ObjectOutput out, Map<String, String> map) throws IOException {
        out.writeInt(map == null ? -1 : map.size());
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                out.writeUTF(e.getKey());
                out.writeUTF(e.getValue());
            }
        }
    }

    public static Map<String, String> readStringMap(ObjectInput in, Map<String, String> map) throws IOException {
        int n = in.readInt();
        if (n < 0) {
            return null;
        }
        map.clear();
        for (int i = 0; i < n; ++i) {
            map.put(in.readUTF(), in.readUTF());
        }
        return map;
    }

    public static void writeArray(ObjectOutput out, byte[] ary) throws IOException {
        if (ary == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(ary.length);
            out.write(ary);
        }
    }

    public static byte[] readByteArray(ObjectInput in) throws IOException {
        int n = in.readInt();
        if (n < 0) {
            return null;
        }
        byte[] b = new byte[n];
        int p = 0;
        int s = 0;
        while (s > -1 && p < n) {
            s = in.read(b, p += s, b.length - p);
        }
        return b;
    }

    public static List<Integer> readIntList(ObjectInput in, List<Integer> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<Integer> list = src == null ? new ArrayList<Integer>(size) : src;
        for (int i = 0; i < size; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    public static void writeIntegerList(ObjectOutput out, List<Integer> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (Integer v : list) {
            out.writeInt(v);
        }
    }

    public static List<Double> readDoubleList(ObjectInput in, List<Double> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<Double> list = src == null ? new ArrayList<Double>(size) : src;
        for (int i = 0; i < size; ++i) {
            list.add(in.readDouble());
        }
        return list;
    }

    public static void writeDoubleList(ObjectOutput out, List<Double> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (Double v : list) {
            out.writeDouble(v);
        }
    }

    public static List<String> readStringList(ObjectInput in, List<String> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<String> list = src == null ? new ArrayList<String>(size) : src;
        for (int i = 0; i < size; ++i) {
            list.add(ExternUtils.readUTF(in));
        }
        return list;
    }

    public static void writeStringList(ObjectOutput out, List<String> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (String v : list) {
            ExternUtils.writeUTF(out, v);
        }
    }

    public static Set<Integer> readIntSet(ObjectInput in, Set<Integer> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<Integer> list = src == null ? new HashSet<Integer>() : src;
        for (int i = 0; i < size; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    public static void writeIntegerSet(ObjectOutput out, Set<Integer> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (Integer v : list) {
            out.writeInt(v);
        }
    }

    public static Set<Double> readDoubleSet(ObjectInput in, Set<Double> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<Double> list = src == null ? new HashSet<Double>() : src;
        for (int i = 0; i < size; ++i) {
            list.add(in.readDouble());
        }
        return list;
    }

    public static void writeDoubleSet(ObjectOutput out, Set<Double> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (Double v : list) {
            out.writeDouble(v);
        }
    }

    public static Set<String> readStringSet(ObjectInput in, Set<String> src) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<String> list = src == null ? new HashSet<String>() : src;
        for (int i = 0; i < size; ++i) {
            list.add(ExternUtils.readUTF(in));
        }
        return list;
    }

    public static void writeStringSet(ObjectOutput out, Set<String> list) throws IOException {
        if (list == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(list.size());
        for (String v : list) {
            ExternUtils.writeUTF(out, v);
        }
    }

    public static void writeEnum(ObjectOutput out, Enum<?> value) throws IOException {
        out.writeShort(value == null ? -1 : value.ordinal());
    }

    public static <T extends Enum<T>> T readEnum(ObjectInput in, Class<? extends Enum<T>> enumValue) throws IOException {
        return ExternUtils.getEnumByOrdinal(in.readShort(), enumValue);
    }

    public static <T extends Enum<T>> T getEnumByOrdinal(int ordinal, Class<? extends Enum<T>> enumValue) throws IOException {
        if (ordinal < 0) {
            return null;
        }
        try {
            Method m = enumValue.getMethod("values", new Class[0]);
            Enum[] values = (Enum[])m.invoke(null, new Object[0]);
            return (T)values[ordinal];
        }
        catch (NoSuchMethodException ex) {
            throw new IOException(ex);
        }
        catch (SecurityException ex) {
            throw new IOException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IOException(ex);
        }
    }
}

