/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.map;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class Timestamp
implements Comparable<Timestamp>,
Serializable {
    static final long serialVersionUID = -5822197440875199087L;
    private long timeStamp;
    private TimeUnit timeUnit;

    public Timestamp() {
    }

    public Timestamp(long timeStamp, TimeUnit timeUnit) {
        this.setTimeStamp(timeStamp);
        this.setTimeUnit(timeUnit);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public final boolean before(long t) {
        return this.before(t, TimeUnit.MILLISECONDS);
    }

    public final boolean before(long t, TimeUnit u) {
        return this.getTimeStamp() < this.getTimeUnit().convert(t, u);
    }

    public final boolean after(long t) {
        return this.after(t, TimeUnit.MILLISECONDS);
    }

    public final boolean after(long t, TimeUnit u) {
        return this.getTimeStamp() > this.getTimeUnit().convert(t, u);
    }

    public final boolean between(long start, long end) {
        return this.between(start, end, TimeUnit.MILLISECONDS);
    }

    public final boolean between(long start, long end, TimeUnit unit) {
        return this.between(start, unit, end, unit);
    }

    public final boolean between(long start, TimeUnit startUnit, long end, TimeUnit endUnit) {
        return this.after(start, startUnit) && this.before(end, endUnit);
    }

    @Override
    public int compareTo(Timestamp t) {
        try {
            return (int)(this.getTimeStamp() - t.getTimeStamp());
        }
        catch (Exception e) {
            long t1 = this.getTimeStamp();
            long t2 = t.getTimeStamp();
            return t1 == t2 ? 0 : (t1 < t2 ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        }
    }
}

