/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.logging.Log;
import uk.org.retep.logging.LogFactory;
import uk.org.retep.util.reference.CleanableWeakReference;
import uk.org.retep.util.thread.DelayedRunnableThreadPoolExecutor;
import uk.org.retep.util.thread.ExecutorFactory;
import uk.org.retep.util.thread.GlobalThreadPool;

@ThreadSafe
public final class ReferenceFactory {
    private static final Log log = LogFactory.getLog(ReferenceFactory.class);
    private static DelayedRunnableThreadPoolExecutor delayPool;
    private static CleanableReferenceQueue referenceQueue;

    private ReferenceFactory() {
    }

    public static synchronized DelayedRunnableThreadPoolExecutor getDelayThreadPoolExecutor() {
        if (delayPool == null) {
            ThreadFactory threadFactory = GlobalThreadPool.createDaemonThreadFactory("ReferenceFactory DelayedRunnable Executor");
            delayPool = new DelayedRunnableThreadPoolExecutor(1, 10, 5L, TimeUnit.MINUTES, threadFactory);
            delayPool.prestartCoreThread();
        }
        return delayPool;
    }

    public static synchronized ReferenceQueue<Object> getReferenceQueue() {
        if (referenceQueue == null) {
            referenceQueue = new CleanableReferenceQueue();
        }
        log.debug("getReferenceQueue");
        referenceQueue.addReference();
        return referenceQueue;
    }

    private static final class CleanableReferenceQueue
    extends ReferenceQueue<Object>
    implements Runnable {
        private int count;

        private CleanableReferenceQueue() {
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                block16: {
                    try {
                        Reference ref = super.remove(0L);
                        if (log.isDebugEnabled()) {
                            log.debug("dequeued reference %s", ref.toString());
                        }
                        if (!(ref instanceof CleanableWeakReference)) {
                            log.warn("A reference not a subclass of CleanableWeakReference has been added to the Utilities.activeReferenceQueue(): %s", ref.getClass());
                            break block16;
                        }
                        try {
                            ((CleanableWeakReference)ref).cleanupReference();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            log.fatal((Object)"Throwable that should not happen has happened, please repoort it as a bug", t);
                        }
                        finally {
                            ref = null;
                        }
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                }
                CleanableReferenceQueue cleanableReferenceQueue = this;
                synchronized (cleanableReferenceQueue) {
                    if (this.count > 0) {
                        --this.count;
                    }
                    if (this.count == 0) {
                        break;
                    }
                }
            }
        }

        synchronized void addReference() {
            if (this.count == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Starting ReferenceQueue thread");
                }
                ExecutorFactory.globalInvokeLater(this);
            } else if (log.isDebugEnabled()) {
                log.debug("Adding reference to queue");
            }
            ++this.count;
        }
    }
}

