/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Contract;
import uk.org.retep.annotations.ReadLock;
import uk.org.retep.annotations.WriteLock;
import uk.org.retep.util.reference.AbstractDelayedWeakReference;

@ThreadSafe
public class DelayedWeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final long DEFAULT_DELAY = 15000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final long delay;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    protected KeySet keySet;
    protected Values values;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public DelayedWeakHashMap() {
        this(15000L);
    }

    public DelayedWeakHashMap(Map<K, V> map) {
        this(15000L, map);
    }

    public DelayedWeakHashMap(int initialCapacity) {
        this(15000L, initialCapacity);
    }

    public DelayedWeakHashMap(int initialCapacity, float loadFactor) {
        this(15000L, initialCapacity, loadFactor);
    }

    public DelayedWeakHashMap(long delay, int initialCapacity) {
        this(15000L, initialCapacity, 0.75f);
    }

    public DelayedWeakHashMap(long delay) {
        this.delay = delay;
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public DelayedWeakHashMap(long delay, int initialCapacity, float loadFactor) {
        int capacity;
        this.delay = delay;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public DelayedWeakHashMap(long delay, Map<? extends K, ? extends V> m) {
        this(delay, Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(m);
    }

    @Contract(value={ReadLock.class})
    protected final Lock readLock() {
        return this.lock.readLock();
    }

    @Contract(value={WriteLock.class})
    protected final Lock writeLock() {
        return this.lock.writeLock();
    }

    protected void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public int size() {
        this.readLock().lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean isEmpty() {
        this.readLock().lock();
        try {
            boolean bl = this.size == 0;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public V get(Object key) {
        this.readLock().lock();
        try {
            if (key == null) {
                V v = this.getForNullKey();
                return v;
            }
            int hash = DelayedWeakHashMap.hash(key.hashCode());
            Entry e = this.table[DelayedWeakHashMap.indexFor(hash, this.table.length)];
            while (e != null) {
                Object k;
                if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                    Object v = e.getValue();
                    return v;
                }
                e = e.next;
            }
            V v = null;
            return v;
        }
        finally {
            this.readLock().unlock();
        }
    }

    private V getForNullKey() {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.getValue();
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean containsKey(Object key) {
        this.readLock().lock();
        try {
            boolean bl = this.getEntry(key) != null;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReadLock
    final Entry<K, V> getEntry(Object key) {
        this.readLock().lock();
        try {
            int hash = key == null ? 0 : DelayedWeakHashMap.hash(key.hashCode());
            Entry e = this.table[DelayedWeakHashMap.indexFor(hash, this.table.length)];
            while (e != null) {
                Object k;
                if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                    Entry entry = e;
                    return entry;
                }
                e = e.next;
            }
            Entry<K, V> entry = null;
            return entry;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public V put(K key, V value) {
        this.writeLock().lock();
        try {
            if (key == null) {
                V v = this.putForNullKey(value);
                return v;
            }
            int hash = DelayedWeakHashMap.hash(key.hashCode());
            int i = DelayedWeakHashMap.indexFor(hash, this.table.length);
            Entry e = this.table[i];
            while (e != null) {
                Object k;
                if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                    Object oldValue = e.setValue(value);
                    e.recordAccess(this);
                    Object v = oldValue;
                    return v;
                }
                e = e.next;
            }
            ++this.modCount;
            this.addEntry(hash, key, value, i);
            V v = null;
            return v;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private V putForNullKey(V value) {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                V oldValue = e.setValue(value);
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return null;
    }

    private void putForCreate(K key, V value) {
        int hash = key == null ? 0 : DelayedWeakHashMap.hash(key.hashCode());
        int i = DelayedWeakHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.setValue(value);
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = DelayedWeakHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void putAll(Map<? extends K, ? extends V> m) {
        this.writeLock().lock();
        try {
            int numKeysToBeAdded = m.size();
            if (numKeysToBeAdded == 0) {
                return;
            }
            if (numKeysToBeAdded > this.threshold) {
                int newCapacity;
                int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
                if (targetCapacity > 0x40000000) {
                    targetCapacity = 0x40000000;
                }
                for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
                }
                if (newCapacity > this.table.length) {
                    this.resize(newCapacity);
                }
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public V remove(Object key) {
        this.writeLock().lock();
        try {
            Entry<K, V> e = this.removeEntryForKey(key);
            V v = e == null ? null : (V)e.getValue();
            return v;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    final Entry<K, V> removeEntryForKey(Object key) {
        this.writeLock().lock();
        try {
            Entry prev;
            int hash = key == null ? 0 : DelayedWeakHashMap.hash(key.hashCode());
            int i = DelayedWeakHashMap.indexFor(hash, this.table.length);
            Entry e = prev = this.table[i];
            while (e != null) {
                Object k;
                Entry next = e.next;
                if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                    ++this.modCount;
                    --this.size;
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.recordRemoval(this);
                    Entry entry = e;
                    return entry;
                }
                prev = e;
                e = next;
            }
            Entry entry = e;
            return entry;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final Entry<K, V> removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : DelayedWeakHashMap.hash(key.hashCode());
        int i = DelayedWeakHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public void clear() {
        this.writeLock().lock();
        try {
            ++this.modCount;
            Entry[] tab = this.table;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
            this.size = 0;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public boolean containsValue(Object value) {
        this.readLock().lock();
        try {
            if (value == null) {
                boolean bl = this.containsNullValue();
                return bl;
            }
            Entry[] tab = this.table;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        boolean bl = true;
                        return bl;
                    }
                    e = e.next;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadLock
    public Object clone() {
        this.readLock().lock();
        try {
            DelayedWeakHashMap result = null;
            try {
                result = (DelayedWeakHashMap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            result.table = new Entry[this.table.length];
            result.entrySet = null;
            result.modCount = 0;
            result.size = 0;
            result.init();
            result.putAllForCreate(this);
            DelayedWeakHashMap delayedWeakHashMap = result;
            return delayedWeakHashMap;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public final long getDelay() {
        return this.delay;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K, V>(hash, key, value, e);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public Set<K> keySet() {
        this.writeLock().lock();
        try {
            KeySet ks = this.keySet;
            KeySet keySet = ks != null ? ks : (this.keySet = new KeySet());
            return keySet;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteLock
    public Collection<V> values() {
        this.writeLock().lock();
        try {
            Values vs = this.values;
            Values values = vs != null ? vs : (this.values = new Values());
            return values;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WriteLock
    private Set<Map.Entry<K, V>> entrySet0() {
        this.writeLock().lock();
        try {
            EntrySet es = this.entrySet;
            EntrySet entrySet = es != null ? es : (this.entrySet = new EntrySet());
            return entrySet;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<Map.Entry<K, V>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.table = new Entry[16];
        this.init();
        this.size = 0;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    @ThreadSafe
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Contract(value={ReadLock.class})
        protected final Lock readLock() {
            return DelayedWeakHashMap.this.readLock();
        }

        @Contract(value={WriteLock.class})
        protected final Lock writeLock() {
            return DelayedWeakHashMap.this.writeLock();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return DelayedWeakHashMap.this.newEntryIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public boolean contains(Object o) {
            this.readLock().lock();
            try {
                if (!(o instanceof Map.Entry)) {
                    boolean bl = false;
                    return bl;
                }
                Map.Entry e = (Map.Entry)o;
                Entry candidate = DelayedWeakHashMap.this.getEntry(e.getKey());
                boolean bl = candidate != null && candidate.equals(e);
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public boolean remove(Object o) {
            this.writeLock().lock();
            try {
                boolean bl = DelayedWeakHashMap.this.removeMapping(o) != null;
                return bl;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public int size() {
            this.readLock().lock();
            try {
                int n = DelayedWeakHashMap.this.size;
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        @Override
        public void clear() {
            DelayedWeakHashMap.this.clear();
        }
    }

    @ThreadSafe
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Contract(value={ReadLock.class})
        protected final Lock readLock() {
            return DelayedWeakHashMap.this.readLock();
        }

        @Contract(value={WriteLock.class})
        protected final Lock writeLock() {
            return DelayedWeakHashMap.this.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public Iterator<V> iterator() {
            this.readLock().lock();
            try {
                Iterator iterator = DelayedWeakHashMap.this.newValueIterator();
                return iterator;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public int size() {
            this.readLock().lock();
            try {
                int n = DelayedWeakHashMap.this.size;
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return DelayedWeakHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            DelayedWeakHashMap.this.clear();
        }
    }

    @ThreadSafe
    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Contract(value={ReadLock.class})
        protected final Lock readLock() {
            return DelayedWeakHashMap.this.readLock();
        }

        @Contract(value={WriteLock.class})
        protected final Lock writeLock() {
            return DelayedWeakHashMap.this.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public Iterator<K> iterator() {
            this.readLock().lock();
            try {
                Iterator iterator = DelayedWeakHashMap.this.newKeyIterator();
                return iterator;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public int size() {
            this.readLock().lock();
            try {
                int n = DelayedWeakHashMap.this.size;
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return DelayedWeakHashMap.this.containsKey(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public boolean remove(Object o) {
            this.writeLock().lock();
            try {
                boolean bl = DelayedWeakHashMap.this.removeEntryForKey(o) != null;
                return bl;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        @Override
        public void clear() {
            DelayedWeakHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = DelayedWeakHashMap.this.modCount;
            if (DelayedWeakHashMap.this.size > 0) {
                Entry[] t = DelayedWeakHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (DelayedWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = DelayedWeakHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (DelayedWeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            DelayedWeakHashMap.this.removeEntryForKey(k);
            this.expectedModCount = DelayedWeakHashMap.this.modCount;
        }
    }

    @ThreadSafe
    class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        Ref<K, V> value;
        Entry<K, V> next;
        final int hash;

        Entry(int h, K k, V v, Entry<K, V> n) {
            this.value = new Ref<K, V>(k, v);
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Contract(value={ReadLock.class})
        protected final Lock readLock() {
            return DelayedWeakHashMap.this.readLock();
        }

        @Contract(value={WriteLock.class})
        protected final Lock writeLock() {
            return DelayedWeakHashMap.this.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public final K getKey() {
            this.readLock().lock();
            try {
                K k = this.key;
                return k;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ReadLock
        public final V getValue() {
            this.readLock().lock();
            try {
                Object t = this.value.get();
                return (V)t;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WriteLock
        public final V setValue(V newValue) {
            this.writeLock().lock();
            try {
                Object oldValue = this.value.get();
                this.value = new Ref<K, V>(this.key, newValue);
                Object t = oldValue;
                return (V)t;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(DelayedWeakHashMap<K, V> m) {
        }

        void recordRemoval(DelayedWeakHashMap<K, V> m) {
        }
    }

    class Ref<K, V>
    extends AbstractDelayedWeakReference<V> {
        private final K key;

        public Ref(K key, V v) {
            super(DelayedWeakHashMap.this.getDelay(), v);
            this.key = key;
        }

        @Override
        protected void remove(V o) {
            DelayedWeakHashMap.this.removeEntryForKey(this.key);
        }

        public String toString() {
            return this.key == null ? null : this.key.toString();
        }
    }
}

