/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import uk.org.retep.swing.model.EnumModel;
import uk.org.retep.util.graphics.Join;
import uk.org.retep.util.string.StringUtils;

public enum JoinEnd implements EnumModel.Renderable
{
    NONE(false),
    ARROW(true),
    ARROW_HOLLOW(false),
    ARROW_OPEN(false),
    CIRCLE(true),
    CIRCLE_HOLLOW(false),
    DIAMOND(true),
    DIAMOND_HOLLOW(false),
    SQUARE(true),
    SQUARE_HOLLOW(false);

    private boolean fill;

    private JoinEnd(boolean fill) {
        this.fill = fill;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void draw(Graphics2D g, int x1, int y1, int x2, int y2) {
        this.draw(g, (float)x1, (float)y1, (float)x2, (float)y2);
    }

    public void draw(Graphics2D g, float x1, float y1, float x2, float y2) {
        GeneralPath p;
        Color fc = g.getColor();
        Color bc = g.getBackground();
        if (this.isFilled()) {
            g.setColor(bc);
            p = new GeneralPath();
            this.appendPath(p, x1, y1, x2, y2, false, true);
            g.fill(p);
        }
        p = new GeneralPath();
        this.appendPath(p, x1, y1, x2, y2, false, false);
        g.setColor(fc);
        g.draw(p);
    }

    private void initialMoveTo(GeneralPath p, float x, float y, boolean lineTo) {
        if (lineTo) {
            p.lineTo(x, y);
        } else {
            p.moveTo(x, y);
        }
    }

    public GeneralPath appendPath(GeneralPath p, float x1, float y1, float x2, float y2, boolean lineTo, boolean forFill) {
        if (p == null) {
            p = new GeneralPath();
        }
        float h = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        this.initialMoveTo(p, x2, y2, lineTo);
        if (forFill && !this.isFilled()) {
            return p;
        }
        if (x1 != x2) {
            switch (this) {
                default: {
                    break;
                }
                case ARROW: 
                case ARROW_HOLLOW: {
                    h = Math.abs(x1 - x2) / 2.0f;
                    p.lineTo(x2, y2 + h);
                    p.lineTo(x1, y1);
                    p.lineTo(x2, y2 - h);
                    p.lineTo(x2, y2);
                    break;
                }
                case ARROW_OPEN: {
                    h = Math.abs(x1 - x2) / 2.0f;
                    p.lineTo(x1, y1);
                    p.lineTo(x2, y1 + h);
                    p.lineTo(x1, y1);
                    p.lineTo(x2, y2 - h);
                    p.lineTo(x1, y1);
                    break;
                }
                case CIRCLE: 
                case CIRCLE_HOLLOW: {
                    h = x1 - x2;
                    p.append(new Ellipse2D.Float(x2, y2 - h / 2.0f, h, h), false);
                    p.moveTo(x2, y2);
                    break;
                }
                case DIAMOND: 
                case DIAMOND_HOLLOW: {
                    dy = (x1 - x2) / 2.0f;
                    dx = (x1 - x2) / 2.0f;
                    p.lineTo(x2 + dx, y2 - dy);
                    p.lineTo(x1, y1);
                    p.lineTo(x2 + dx, y2 + dy);
                    p.lineTo(x2, y2);
                    break;
                }
                case SQUARE: 
                case SQUARE_HOLLOW: {
                    dy = (x1 - x2) / 2.0f;
                    p.lineTo(x2, y2 - dy);
                    p.lineTo(x1, y2 - dy);
                    p.lineTo(x1, y2 + dy);
                    p.lineTo(x2, y2 + dy);
                    p.lineTo(x2, y2);
                    break;
                }
            }
        } else {
            switch (this) {
                default: {
                    break;
                }
                case ARROW: 
                case ARROW_HOLLOW: {
                    h = Math.abs(y1 - y2) / 2.0f;
                    p.lineTo(x2 + h, y2);
                    p.lineTo(x1, y1);
                    p.lineTo(x2 - h, y2);
                    p.lineTo(x2, y2);
                    break;
                }
                case ARROW_OPEN: {
                    h = Math.abs(x1 - x2) / 2.0f;
                    p.lineTo(x1, y1);
                    p.lineTo(x2 + h, y1);
                    p.lineTo(x1, y1);
                    p.lineTo(x2 - h, y2);
                    p.lineTo(x1, y1);
                    break;
                }
                case CIRCLE: 
                case CIRCLE_HOLLOW: {
                    h = Math.abs(y1 - y2);
                    p.append(new Ellipse2D.Float(x2 - h / 2.0f, y2, h, h), false);
                    p.moveTo(x2, y2);
                    break;
                }
                case DIAMOND: 
                case DIAMOND_HOLLOW: {
                    dx = (y1 - y2) / 2.0f;
                    dx = (y1 - y2) / 2.0f;
                    p.lineTo(x2 + dx, y2 + dy);
                    p.lineTo(x1, y1);
                    p.lineTo(x2 - dx, y2 + dy);
                    p.lineTo(x2, y2);
                    break;
                }
                case SQUARE: 
                case SQUARE_HOLLOW: {
                    dx = (y1 - y2) / 2.0f;
                    p.lineTo(x2 - dx, y2);
                    p.lineTo(x1 - dx, y2);
                    p.lineTo(x1 + dx, y2);
                    p.lineTo(x2 + dx, y2);
                    p.lineTo(x2, y2);
                }
            }
        }
        return p;
    }

    public Point2D.Float getJoinPoint(int x1, int y1, int x2, int y2) {
        return this.getJoinPoint((float)x1, (float)y1, (float)x2, (float)y2);
    }

    public Point2D.Float getJoinPoint(float x1, float y1, float x2, float y2) {
        switch (this) {
            default: {
                return new Point2D.Float(x1, y1);
            }
            case ARROW: 
            case ARROW_HOLLOW: 
            case ARROW_OPEN: 
            case CIRCLE: 
            case CIRCLE_HOLLOW: 
            case DIAMOND: 
            case DIAMOND_HOLLOW: 
            case SQUARE: 
            case SQUARE_HOLLOW: 
        }
        if (x1 != x2) {
            return new Point2D.Float(x1 + (x1 < x2 ? 6.0f : -6.0f), y1);
        }
        return new Point2D.Float(x1, y1 + (y1 < y2 ? 6.0f : -6.0f));
    }

    @Override
    public String getDescription() {
        return StringUtils.capitaliseEnum(this.toString());
    }

    @Override
    public void render(Graphics2D g, int w, int h) {
        double x1 = ((double)w - 8.0) / 4.0;
        double x2 = x1 + x1 + x1;
        double x4 = x2 + x1 + x1 + x1;
        double y = (double)h / 2.0;
        Join.STRAIGHT.draw(g, x1, y, x2, y, x2, y, x4, y, NONE, this);
    }
}

