/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedCharReader {
    private final Reader reader;
    private final char[] buffer;
    private final int limit;
    private int pos;
    private int end;
    private boolean eof = false;

    public BufferedCharReader(Reader reader) {
        this(reader, 1024);
    }

    public BufferedCharReader(Reader reader, int limit) {
        this.reader = reader;
        this.limit = limit;
        this.buffer = new char[limit];
        this.end = 0;
        this.pos = 0;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLimit() {
        return this.buffer.length;
    }

    public int getAvailable() {
        return this.end - this.pos;
    }

    public void reset() {
        if (this.pos > 0 && this.pos < this.end) {
            System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.end - this.pos);
            this.end -= this.pos;
        } else {
            this.end = 0;
        }
        this.pos = 0;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void fill() throws IOException {
        int s;
        if (this.eof) {
            return;
        }
        if (this.pos >= this.end) {
            this.reset();
        }
        if ((s = this.reader.read(this.buffer, this.end, this.limit - this.end)) >= 0) {
            this.end += s;
        } else {
            this.eof = true;
        }
    }

    public void ensureCapacity() throws IOException {
        this.ensureCapacity(this.limit);
    }

    public void ensureCapacity(int length) throws IOException {
        if (length > this.limit) {
            throw new IllegalArgumentException("required length " + length + " is greater than limit " + this.limit);
        }
        if (this.pos + length > this.limit) {
            this.reset();
        }
        while (!this.isEof() && this.pos + length > this.end) {
            this.fill();
        }
    }

    public char getCurrent() throws IOException {
        if (this.pos >= this.end) {
            this.fill();
        }
        if (this.pos >= this.end) {
            return '\uffff';
        }
        return this.buffer[this.pos];
    }

    public int copy(char[] dest, int length) throws IOException {
        this.ensureCapacity(length);
        int trueLength = Math.min(this.end - this.pos, length);
        if (trueLength > 0) {
            System.arraycopy(this.buffer, this.pos, dest, 0, trueLength);
        }
        return trueLength;
    }

    public void moveForward(int p) throws IOException {
        int d;
        if (p < 0) {
            throw new IllegalArgumentException("Cannot move backwards");
        }
        for (int c = p; c > 0; c -= d) {
            d = Math.min(c, Math.min(this.end, this.limit));
            this.pos += d;
            if (this.pos < this.end) continue;
            this.fill();
        }
        this.fill();
    }
}

