/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.comparators;

import java.util.Comparator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class JMXComparators {
    private static MBeanAttributeInfoComparator mBeanAttributeInfoComparator;
    private static MBeanOperationInfoComparator mBeanOperationInfoComparator;
    private static ObjectNameKeyComparator objectNameKeyComparator;

    public static Comparator<MBeanAttributeInfo> getMBeanAttributeInfoComparator() {
        if (mBeanAttributeInfoComparator == null) {
            mBeanAttributeInfoComparator = new MBeanAttributeInfoComparator();
        }
        return mBeanAttributeInfoComparator;
    }

    public static Comparator<MBeanOperationInfo> getMBeanOperationInfoComparator() {
        if (mBeanOperationInfoComparator == null) {
            mBeanOperationInfoComparator = new MBeanOperationInfoComparator();
        }
        return mBeanOperationInfoComparator;
    }

    public static Comparator<ObjectName> getObjectNameKeyComparator() {
        if (objectNameKeyComparator == null) {
            objectNameKeyComparator = new ObjectNameKeyComparator();
        }
        return objectNameKeyComparator;
    }

    private static class ObjectNameKeyComparator
    implements Comparator<ObjectName> {
        private ObjectNameKeyComparator() {
        }

        @Override
        public int compare(ObjectName a, ObjectName b) {
            return a.getKeyPropertyListString().compareToIgnoreCase(b.getKeyPropertyListString());
        }
    }

    private static class MBeanOperationInfoComparator
    implements Comparator<MBeanOperationInfo> {
        private MBeanOperationInfoComparator() {
        }

        @Override
        public int compare(MBeanOperationInfo a, MBeanOperationInfo b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }

    private static class MBeanAttributeInfoComparator
    implements Comparator<MBeanAttributeInfo> {
        private MBeanAttributeInfoComparator() {
        }

        @Override
        public int compare(MBeanAttributeInfo a, MBeanAttributeInfo b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }
}

