/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.queue.DelayedBlockingQueue;
import uk.org.retep.util.thread.DelayedRunnable;
import uk.org.retep.util.thread.ExecutorFactory;
import uk.org.retep.util.thread.GlobalThreadPool;
import uk.org.retep.util.thread.ShutdownManager;

@ThreadSafe
public class DelayedRunnableThreadPoolExecutor
extends ThreadPoolExecutor {
    private static DelayedRunnableThreadPoolExecutor instance = new DelayedRunnableThreadPoolExecutor();

    @Deprecated
    public static DelayedRunnableThreadPoolExecutor getInstance() {
        return instance;
    }

    DelayedRunnableThreadPoolExecutor() {
        this(1);
        ShutdownManager.addExecutorServiceShutdown(this);
    }

    public DelayedRunnableThreadPoolExecutor(int corePoolSize) {
        this(corePoolSize, corePoolSize * 10);
    }

    public DelayedRunnableThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, 5L, TimeUnit.MINUTES);
    }

    public DelayedRunnableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, GlobalThreadPool.createDaemonThreadFactory("DelayedRunnable Executor"));
    }

    public DelayedRunnableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new DelayedBlockingQueue(), threadFactory);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (command instanceof DelayedRunnable) {
            this.execute((DelayedRunnable)DelayedRunnable.class.cast(command));
        } else {
            this.reject(command);
        }
    }

    public void execute(DelayedRunnable command) {
        super.execute(command);
    }

    public boolean remove(DelayedRunnable task) {
        return super.remove(task);
    }

    public boolean contains(DelayedRunnable task) {
        return this.getQueue().contains(task);
    }

    void reject(Runnable task) {
        this.getRejectedExecutionHandler().rejectedExecution(task, this);
    }

    @Override
    protected void beforeExecute(Thread arg0, Runnable arg1) {
        ExecutorFactory.threadType.set(ExecutorFactory.ThreadType.DELAYED);
        super.beforeExecute(arg0, arg1);
    }

    @Override
    protected void afterExecute(Runnable arg0, Throwable arg1) {
        super.afterExecute(arg0, arg1);
        ExecutorFactory.threadType.remove();
    }
}

