/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.random;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.random.RandomSeedGenerator;

@ThreadSafe
public class FileSeedGenerator
implements RandomSeedGenerator {
    private final File file;

    public FileSeedGenerator(File file) {
        this.file = file;
    }

    @Override
    public byte[] generateSeed(int seedLength) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
            byte[] randomSeed = new byte[seedLength];
            for (int count = 0; count < seedLength && count != -1; count += fis.read(randomSeed, count, seedLength - count)) {
            }
            byte[] byArray = randomSeed;
            return byArray;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading from " + this.getName(), ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    @Override
    public final String getName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Service(value=RandomSeedGenerator.class)
    public static class DevUrandomSeedGenerator
    extends FileSeedGenerator {
        public DevUrandomSeedGenerator() {
            super(new File("/dev/urandom"));
        }

        @Override
        public int getPriority() {
            return 40;
        }
    }

    @Service(value=RandomSeedGenerator.class)
    public static class DevRandomSeedGenerator
    extends FileSeedGenerator {
        public DevRandomSeedGenerator() {
            super(new File("/dev/random"));
        }

        @Override
        public int getPriority() {
            return 30;
        }
    }
}

