/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SingletonSet<E>
implements Set<E>,
Serializable {
    static final long serialVersionUID = -61064384785904649L;
    private ConcurrentHashMap<E, E> map = new ConcurrentHashMap();
    private AtomicInteger savedCount = new AtomicInteger(0);

    public E getSingleton(E e) {
        if (e == null) {
            return null;
        }
        E first = this.map.putIfAbsent(e, e);
        if (first == null) {
            return e;
        }
        this.savedCount.incrementAndGet();
        return first;
    }

    public int getSavedCount() {
        return this.savedCount.intValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object e : c) {
            changed |= this.remove(e);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            Object e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }
}

