/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.annotation.validator;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import uk.org.retep.annotations.NoInstance;
import uk.org.retep.annotations.Singleton;
import uk.org.retep.util.annotation.validator.AbstractCodeAnalyser;
import uk.org.retep.util.javac.JavacUtils;

public class AnnotationScanner
extends AbstractCodeAnalyser {
    public AnnotationScanner(JavacUtils javacUtils) {
        super(javacUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClass(ClassTree node, Trees trees) {
        Meta meta = new Meta();
        meta.classTree = node;
        this.push(meta);
        try {
            Element e = this.getCurrentElement();
            Set<Modifier> modifiers = node.getModifiers().getFlags();
            meta.classFinal = modifiers.contains((Object)Modifier.FINAL);
            meta.classAbstract = modifiers.contains((Object)Modifier.ABSTRACT);
            meta.classNoInstance = JavacUtils.getAnnotation(e, NoInstance.class) != null;
            meta.classSingleton = JavacUtils.getAnnotation(e, Singleton.class) != null;
            this.scan(node.getModifiers(), trees);
            this.scan(node.getTypeParameters(), trees);
            this.scan(node.getExtendsClause(), trees);
            this.scan(node.getImplementsClause(), trees);
            for (Tree tree : node.getMembers()) {
                if (tree.getKind() == Tree.Kind.METHOD) continue;
                this.scan(tree, trees);
            }
            for (Tree tree : node.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD) continue;
                this.scan(tree, trees);
            }
            if (meta.classSingleton) {
                if (!meta.hasInstanceField && !meta.hasInstanceMethod) {
                    this.error(e, Singleton.class, "singleton.noinstance", new Object[0]);
                }
                if (!meta.hasStaticAccessor) {
                    this.error(e, Singleton.class, "singleton.noaccessor", new Object[0]);
                }
            }
            if (meta.classNoInstance) {
                if (meta.hasInstanceField || meta.hasInstanceMethod) {
                    this.error(e, NoInstance.class, "noinstance.instance", new Object[0]);
                }
                if (meta.hasStaticAccessor) {
                    this.error(e, NoInstance.class, "noinstance.accessor", new Object[0]);
                }
            }
        }
        finally {
            this.pop();
            this.report();
        }
        return null;
    }

    @Override
    public Object visitMethod(MethodTree node, Trees trees) {
        ElementKind kind;
        Meta meta = (Meta)this.getMetaData();
        Set<Modifier> modifiers = node.getModifiers().getFlags();
        boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC);
        boolean isPrivate = modifiers.contains((Object)Modifier.PRIVATE);
        boolean isProtected = modifiers.contains((Object)Modifier.PROTECTED);
        boolean isPackage = !isPublic && !isPrivate && !isProtected;
        boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
        Element e = this.getCurrentElement();
        if (meta.classNoInstance && meta.classSingleton) {
            this.error(e, "noinstance.singleton", new Object[0]);
        }
        ElementKind elementKind = kind = e == null ? null : e.getKind();
        if (kind != null) {
            switch (e.getKind()) {
                case CONSTRUCTOR: {
                    if (node.getParameters().isEmpty()) {
                        meta.hasPackageDefaultConstructor = isPackage;
                        meta.hasPrivateDefaultConstructor = isPrivate;
                        meta.hasPublicDefaultConstructor = isPublic;
                        if (!meta.classNoInstance || isPrivate) break;
                        this.error(e, NoInstance.class, "noinstance.default.constructor", new Object[0]);
                        break;
                    }
                    meta.hasPackageNonDefaultConstructor = isPackage;
                    meta.hasPrivateNonDefaultConstructor = isPrivate;
                    meta.hasPublicNonDefaultConstructor = isPublic;
                    if (meta.classSingleton) {
                        this.error(e, Singleton.class, "constructor.nondefault", new Object[0]);
                    }
                    if (!meta.classNoInstance) break;
                    this.error(e, NoInstance.class, "constructor.nondefault", new Object[0]);
                    break;
                }
                case METHOD: {
                    if (isStatic) {
                        if (isPublic && JavacUtils.doesMethodReturnClass(node, meta.classTree)) {
                            if (node.getParameters().isEmpty()) {
                                meta.hasStaticAccessor = true;
                            } else if (meta.classSingleton) {
                                this.error(e, Singleton.class, "singleton.instance.ref.noargs", new Object[0]);
                            }
                        }
                    } else {
                        meta.hasInstanceMethod = true;
                        meta.hasPublicInstanceMethod |= isPublic;
                        if (meta.classNoInstance) {
                            this.error(e, NoInstance.class, "noinstance.instance.method", new Object[0]);
                        }
                    }
                    if (!isProtected) break;
                    if (meta.classSingleton) {
                        this.error(e, Singleton.class, "protected.useless", new Object[0]);
                        break;
                    }
                    if (!meta.classNoInstance) break;
                    this.error(e, NoInstance.class, "protected.useless", new Object[0]);
                    break;
                }
            }
        }
        this.scan(node.getBody(), trees);
        return null;
    }

    @Override
    public Object visitVariable(VariableTree node, Trees trees) {
        Element e = this.getCurrentElement();
        if (JavacUtils.isElementKind(e, ElementKind.FIELD)) {
            Meta meta = (Meta)this.getMetaData();
            Set<Modifier> modifiers = node.getModifiers().getFlags();
            boolean isPublic = modifiers.contains((Object)Modifier.PUBLIC);
            boolean isPrivate = modifiers.contains((Object)Modifier.PRIVATE);
            boolean isProtected = modifiers.contains((Object)Modifier.PROTECTED);
            boolean isPackage = !isPublic && !isPrivate && !isProtected;
            boolean isStatic = modifiers.contains((Object)Modifier.STATIC);
            if (!isStatic) {
                meta.hasInstanceField = true;
                meta.hasPublicInstanceField |= isPublic;
                if (meta.classNoInstance) {
                    this.error(e, NoInstance.class, "noinstance.instance.field", new Object[0]);
                }
            }
            if (isProtected) {
                if (meta.classSingleton) {
                    this.error(e, Singleton.class, "protected.useless", new Object[0]);
                } else if (meta.classNoInstance) {
                    this.error(e, NoInstance.class, "protected.useless", new Object[0]);
                }
            }
            if (JavacUtils.doesVariableMatchClass(node, meta.classTree)) {
                if (meta.classNoInstance) {
                    this.error(e, NoInstance.class, "noinstance.instance.ref", new Object[0]);
                }
                if (meta.classSingleton && !isStatic) {
                    this.error(e, Singleton.class, "singleton.instance.ref.nonstatic", new Object[0]);
                }
            }
        }
        return null;
    }

    private static class Meta
    extends AbstractCodeAnalyser.MetaData {
        ClassTree classTree;
        boolean classFinal;
        boolean classAbstract;
        boolean classSingleton;
        boolean classNoInstance;
        boolean hasPackageDefaultConstructor;
        boolean hasPublicDefaultConstructor;
        boolean hasPrivateDefaultConstructor;
        boolean hasPackageNonDefaultConstructor;
        boolean hasPublicNonDefaultConstructor;
        boolean hasPrivateNonDefaultConstructor;
        boolean hasStaticAccessor;
        boolean hasInstanceField;
        boolean hasPublicInstanceField;
        boolean hasInstanceMethod;
        boolean hasPublicInstanceMethod;

        private Meta() {
        }
    }
}

