/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.zip;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import uk.org.retep.logging.Log;
import uk.org.retep.util.io.AbstractFileVisitor;
import uk.org.retep.util.io.FileUtils;
import uk.org.retep.util.string.StringUtils;

public class ZipFileVisitor
extends AbstractFileVisitor {
    private final ZipOutputStream zos;
    private String baseDir;
    private String dirPrefix;

    public ZipFileVisitor(ZipOutputStream zos) {
        this((Log)null, zos);
    }

    public ZipFileVisitor(Log log, ZipOutputStream zos) {
        this(log, "Added %s to zip", zos);
    }

    public ZipFileVisitor(Log log, String message, ZipOutputStream zos) {
        super(log, message);
        this.zos = zos;
    }

    public ZipFileVisitor(ZipOutputStream zos, File baseDir) throws IOException {
        this((Log)null, zos);
        this.setBaseDir(baseDir);
    }

    public ZipFileVisitor(Log log, ZipOutputStream zos, File baseDir) throws IOException {
        this(log, zos);
        this.setBaseDir(baseDir);
    }

    public ZipFileVisitor(Log log, String message, ZipOutputStream zos, File baseDir) throws IOException {
        this(log, message, zos);
        this.setBaseDir(baseDir);
    }

    public void setDirPrefix(String dirPrefix) {
        this.dirPrefix = dirPrefix == null || dirPrefix.endsWith("/") ? dirPrefix : dirPrefix + "/";
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir == null ? "" : baseDir;
    }

    public void setBaseDir(File baseDir) throws IOException {
        this.baseDir = baseDir == null ? "" : baseDir.getCanonicalPath();
    }

    @Override
    protected boolean execute(File file) throws IOException {
        String name = file.getCanonicalPath();
        name = this.baseDir != null && name.startsWith(this.baseDir) ? name.substring(this.baseDir.length() + 1) : file.getName();
        if (StringUtils.isStringNotEmpty(this.dirPrefix)) {
            name = this.dirPrefix + name;
        }
        ZipEntry ze = new ZipEntry(name);
        this.zos.putNextEntry(ze);
        FileUtils.copyFile(file, this.zos);
        this.zos.closeEntry();
        return true;
    }
}

