/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io.tar;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.org.retep.util.io.tar.InvalidHeaderException;
import uk.org.retep.util.io.tar.TarBuffer;
import uk.org.retep.util.io.tar.TarEntry;

public class TarInputStream
extends FilterInputStream {
    protected boolean debug;
    protected boolean hasHitEOF;
    protected long entrySize;
    protected long entryOffset;
    protected byte[] oneBuf;
    protected byte[] readBuf;
    protected TarBuffer buffer;
    protected TarEntry currEntry;
    protected EntryFactory eFactory;

    public TarInputStream(InputStream is) {
        this(is, 10240, 512);
    }

    public TarInputStream(InputStream is, int blockSize) {
        this(is, blockSize, 512);
    }

    public TarInputStream(InputStream is, int blockSize, int recordSize) {
        super(is);
        this.buffer = new TarBuffer(is, blockSize, recordSize);
        this.readBuf = null;
        this.oneBuf = new byte[1];
        this.debug = false;
        this.hasHitEOF = false;
        this.eFactory = null;
    }

    public void setDebug(boolean debugF) {
        this.debug = debugF;
    }

    public void setEntryFactory(EntryFactory factory) {
        this.eFactory = factory;
    }

    public void setBufferDebug(boolean debug) {
        this.buffer.setDebug(debug);
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.entrySize - this.entryOffset);
    }

    @Override
    public long skip(long numToSkip) throws IOException {
        long num;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (num = numToSkip; num > 0L && (numRead = this.read(skipBuf, 0, num > (long)skipBuf.length ? skipBuf.length : (int)num)) != -1; num -= (long)numRead) {
        }
        return numToSkip - num;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int markLimit) {
    }

    @Override
    public void reset() {
    }

    public long getEntryPosition() {
        return this.entryOffset;
    }

    public long getStreamPosition() {
        return this.buffer.getBlockSize() * this.buffer.getCurrentBlockNum() + this.buffer.getCurrentRecordNum();
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long numToSkip = this.entrySize - this.entryOffset;
            if (this.debug) {
                System.err.println("TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes");
            }
            if (numToSkip > 0L) {
                this.skip(numToSkip);
            }
            this.readBuf = null;
        }
        if ((headerBuf = this.buffer.readRecord()) == null) {
            if (this.debug) {
                System.err.println("READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            if (this.debug) {
                System.err.println("READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = this.eFactory == null ? new TarEntry(headerBuf) : this.eFactory.createEntry(headerBuf);
                if (this.debug) {
                    System.err.println("TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
                }
                this.entryOffset = 0L;
                this.entrySize = this.currEntry.getSize();
            }
            catch (InvalidHeaderException ex) {
                this.entrySize = 0L;
                this.entryOffset = 0L;
                this.currEntry = null;
                throw new InvalidHeaderException("bad header in block " + this.buffer.getCurrentBlockNum() + " record " + this.buffer.getCurrentRecordNum() + ", " + ex.getMessage());
            }
        }
        return this.currEntry;
    }

    @Override
    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        if (num == -1) {
            return num;
        }
        return this.oneBuf[0];
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        int totalRead = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)numToRead + this.entryOffset > this.entrySize) {
            numToRead = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int sz = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buf, offset, sz);
            if (sz >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLen = this.readBuf.length - sz;
                byte[] newBuf = new byte[newLen];
                System.arraycopy(this.readBuf, sz, newBuf, 0, newLen);
                this.readBuf = newBuf;
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (rec == null) {
                throw new IOException("unexpected EOF with " + numToRead + " bytes unread");
            }
            int recLen = rec.length;
            int sz = numToRead;
            if (recLen > sz) {
                System.arraycopy(rec, 0, buf, offset, sz);
                this.readBuf = new byte[recLen - sz];
                System.arraycopy(rec, sz, this.readBuf, 0, recLen - sz);
            } else {
                sz = recLen;
                System.arraycopy(rec, 0, buf, offset, recLen);
            }
            totalRead += sz;
            numToRead -= sz;
            offset += sz;
        }
        this.entryOffset += (long)totalRead;
        return totalRead;
    }

    public void copyEntryContents(OutputStream out) throws IOException {
        int numRead;
        byte[] buf = new byte[32768];
        while ((numRead = this.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, numRead);
        }
    }

    public class EntryAdapter
    implements EntryFactory {
        @Override
        public TarEntry createEntry(String name) {
            return new TarEntry(name);
        }

        @Override
        public TarEntry createEntry(File path) throws InvalidHeaderException {
            return new TarEntry(path);
        }

        @Override
        public TarEntry createEntry(byte[] headerBuf) throws InvalidHeaderException {
            return new TarEntry(headerBuf);
        }
    }

    public static interface EntryFactory {
        public TarEntry createEntry(String var1);

        public TarEntry createEntry(File var1) throws InvalidHeaderException;

        public TarEntry createEntry(byte[] var1) throws InvalidHeaderException;
    }
}

