/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.http;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import net.jcip.annotations.ThreadSafe;
import uk.org.retep.util.collections.ConcurrencySupport;

@ThreadSafe
public class SimpleHttpServer
extends ConcurrencySupport {
    private HttpServer httpServer;
    private HttpsServer httpsServer;
    private boolean started;

    public SimpleHttpServer() {
    }

    public SimpleHttpServer(int httpPort, int httpBacklog) throws IOException {
        this.createHttpServer(httpPort, httpBacklog);
    }

    public SimpleHttpServer(int httpPort, int httpsPort, int backlog) throws IOException, NoSuchAlgorithmException {
        this(httpPort, backlog, httpsPort, backlog);
    }

    public SimpleHttpServer(int httpPort, int httpBacklog, int httpsPort, int httpsBacklog) throws IOException, NoSuchAlgorithmException {
        this.createHttpServer(httpPort, httpBacklog);
        this.createHttpsServer(httpsPort, httpsBacklog);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HttpsServer getHttpsServer() {
        return this.httpsServer;
    }

    public final void createHttpServer(int port, int backlog) throws IOException {
        if (port > 0) {
            this.createHttpServer(new InetSocketAddress(port), backlog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createHttpServer(InetSocketAddress socket, int backlog) throws IOException {
        this.writeLock().lock();
        try {
            if (this.httpServer != null) {
                throw new IllegalStateException("An HttpServer has already been created");
            }
            if (this.started) {
                throw new IllegalStateException("The server(s) have already been started");
            }
            this.getLog().info("Creating HttpServer listening on %s backlog %d", socket, backlog);
            this.httpServer = HttpServer.create(socket, backlog);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public final void createHttpsServer(int port, int backlog) throws IOException, NoSuchAlgorithmException {
        if (port > 0) {
            this.createHttpsServer(new InetSocketAddress(port), backlog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createHttpsServer(InetSocketAddress socket, int backlog) throws IOException, NoSuchAlgorithmException {
        this.writeLock().lock();
        try {
            if (this.httpsServer != null) {
                throw new IllegalStateException("An HttpsServer has already been created");
            }
            if (this.started) {
                throw new IllegalStateException("The server(s) have already been started");
            }
            this.getLog().info("Creating HttpsServer listening on %s backlog %d", socket, backlog);
            this.httpsServer = HttpsServer.create(socket, backlog);
            this.httpsServer.setHttpsConfigurator(new HttpsConfigurator(SSLContext.getDefault()){

                @Override
                public void configure(HttpsParameters params) {
                    SSLContext sslContext = this.getSSLContext();
                    SSLParameters sslParams = sslContext.getDefaultSSLParameters();
                    params.setSSLParameters(sslParams);
                    super.configure(params);
                }
            });
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExecutor(Executor executor) {
        this.writeLock().lock();
        try {
            if (this.started) {
                throw new IllegalStateException("The server(s) have already been started");
            }
            if (this.httpServer != null) {
                this.httpServer.setExecutor(executor);
            }
            if (this.httpsServer != null) {
                this.httpsServer.setExecutor(executor);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.writeLock().lock();
        try {
            if (this.started) {
                return;
            }
            if (this.httpServer == null && this.httpsServer == null) {
                throw new IllegalStateException("No HttpServer or HttpsServer has been created");
            }
            if (this.httpServer != null) {
                this.getLog().info("Starting HttpServer listening on %s", this.httpServer.getAddress());
                this.httpServer.start();
            }
            if (this.httpsServer != null) {
                this.getLog().info("Starting HttpsServer listening on %s", this.httpsServer.getAddress());
                this.httpsServer.start();
            }
            this.started = true;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public final void stop() {
        this.stop(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(int delay) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                return;
            }
            if (this.httpServer != null) {
                this.getLog().info("Stopping HttpServer listening on %s delay %d", this.httpServer.getAddress(), delay);
                this.httpServer.stop(delay);
            }
            if (this.httpsServer != null) {
                this.getLog().info("Stopping HttpsServer listening on %s delay %d", this.httpsServer.getAddress(), delay);
                this.httpsServer.stop(delay);
            }
            this.started = false;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    public final boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpContext createHttpContext(String path, HttpHandler handler) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                this.start();
            }
            if (this.httpServer == null) {
                throw new IllegalStateException("No HttpServer has been created");
            }
            this.getLog().info("Creating HttpContext %s on HttpServer %s", path, this.httpServer.getAddress());
            HttpContext httpContext = this.httpServer.createContext(path, handler);
            return httpContext;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpContext(String path) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                return;
            }
            if (this.httpServer == null) {
                throw new IllegalStateException("No HttpServer has been created");
            }
            this.getLog().info("Removing HttpContext %s on HttpServer %s", path, this.httpServer.getAddress());
            this.httpServer.removeContext(path);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpContext(HttpContext context) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                return;
            }
            if (this.httpServer == null) {
                throw new IllegalStateException("No HttpServer has been created");
            }
            this.getLog().info("Removing HttpContext %s on HttpServer %s", context.getPath(), this.httpServer.getAddress());
            this.httpServer.removeContext(context);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpContext createHttpsContext(String path, HttpHandler handler) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                this.start();
            }
            if (this.httpsServer == null) {
                throw new IllegalStateException("No HttpSServer has been created");
            }
            this.getLog().info("Creating HttpContext %s on HttpsServer %s", path, this.httpsServer.getAddress());
            HttpContext httpContext = this.httpsServer.createContext(path, handler);
            return httpContext;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpsContext(String path) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                return;
            }
            if (this.httpsServer == null) {
                throw new IllegalStateException("No HttpsServer has been created");
            }
            this.getLog().info("Removing HttpContext %s on HttpsServer %s", path, this.httpsServer.getAddress());
            this.httpsServer.removeContext(path);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHttpsContext(HttpContext context) {
        this.writeLock().lock();
        try {
            if (!this.started) {
                return;
            }
            if (this.httpsServer == null) {
                throw new IllegalStateException("No HttpsServer has been created");
            }
            this.getLog().info("Removing HttpContext %s on HttpsServer %s", context.getPath(), this.httpsServer.getAddress());
            this.httpsServer.removeContext(context);
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

