/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.annotations.Encoding;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.nio.charset.AbstractCharset;
import uk.org.retep.util.nio.charset.Charset;

@Encoding(value={"UTF-8", "UTF_8", "UTF8", "unicode-1-1-utf-8"})
@Service(value=Charset.class)
public class UTF_8
extends AbstractCharset {
    public final boolean isContinuation(int b) {
        return (b & 0xC0) == 128;
    }

    @Override
    public char decode(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return '\uffff';
        }
        int pos = buffer.position();
        byte b1 = buffer.get();
        switch (b1 >> 4 & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (char)(b1 & 0x7F);
            }
            case 12: 
            case 13: {
                byte b2;
                if (!buffer.hasRemaining() || !this.isContinuation(b2 = buffer.get())) break;
                return (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
            }
            case 14: {
                if (buffer.remaining() <= 2) break;
                byte b2 = buffer.get();
                byte b3 = buffer.get();
                if (!this.isContinuation(b2) || !this.isContinuation(b3)) break;
                return (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
            }
            default: {
                return '\ufffe';
            }
        }
        buffer.position(pos);
        return '\uffff';
    }

    @Override
    public boolean encode(ByteBuffer buffer, char c) {
        if (c < '\u0080') {
            if (buffer.hasRemaining()) {
                buffer.put((byte)c);
                return true;
            }
        } else if (c < '\u0800') {
            if (buffer.remaining() > 1) {
                buffer.put((byte)(0xC0 | c >> 6));
                buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                return true;
            }
        } else if (c <= '\uffff' && buffer.remaining() > 2) {
            buffer.put((byte)(0xE0 | c >> 12));
            buffer.put((byte)(0x80 | c >> 6 & 0x3F));
            buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        return false;
    }

    @Override
    public int size(char c) {
        if (c < '\u0080') {
            return 1;
        }
        if (c < '\u0800') {
            return 2;
        }
        if (c <= '\uffff') {
            return 3;
        }
        return 0;
    }
}

