/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.annotations.Encoding;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.nio.charset.AbstractUTF_16;
import uk.org.retep.util.nio.charset.Charset;

@Encoding(value={"UTF-16", "UTF_16", "utf16", "unicode", "UnicodeBig"})
@Service(value=Charset.class)
public class UTF_16
extends AbstractUTF_16 {
    private Endian endian = Endian.NONE;
    private boolean requiresBOM;

    public boolean isRequiresBOM() {
        return this.requiresBOM;
    }

    public void setRequiresBOM(boolean requiresBOM) {
        if (this.endian != Endian.NONE) {
            throw new IllegalStateException("Cannot set requiresDOM once the stream has been used");
        }
        this.requiresBOM = requiresBOM;
    }

    @Override
    public Charset getInstance() {
        return new UTF_16();
    }

    @Override
    public char decode(ByteBuffer buffer) {
        if (buffer.remaining() < 2) {
            return '\uffff';
        }
        if (this.endian == Endian.BIG) {
            return this.decodeBig(buffer.get(), buffer.get());
        }
        return this.decodeLittle(buffer.get(), buffer.get());
    }

    @Override
    public boolean encode(ByteBuffer buffer, char c) {
        if (this.endian == Endian.BIG) {
            return this.encodeBig(buffer, c);
        }
        if (this.endian == Endian.LITTLE) {
            return this.encodeLittle(buffer, c);
        }
        if (c == '\ufffe') {
            this.endian = Endian.LITTLE;
        } else if (c == '\ufeff') {
            this.endian = Endian.BIG;
        } else if (this.requiresBOM && !this.encodeBig(buffer, '\ufeff')) {
            return false;
        }
        this.endian = Endian.BIG;
        return this.encodeBig(buffer, c);
    }

    public static enum Endian {
        NONE,
        BIG,
        LITTLE;

    }
}

