/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.nio.charset;

import java.nio.ByteBuffer;
import uk.org.retep.annotations.Encoding;
import uk.org.retep.annotations.Service;
import uk.org.retep.util.nio.charset.AbstractCharset;
import uk.org.retep.util.nio.charset.Charset;

@Encoding(value={"US-ASCII", "US_ASCII", "iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "us", "IBM367", "cp367", "csASCII", "default", "646", "iso_646.irv:1983", "ANSI_X3.4-1968", "ascii7"})
@Service(value=Charset.class)
public class US_ASCII
extends AbstractCharset {
    @Override
    public char decode(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b < 128) {
                return (char)b;
            }
            return '\ufffe';
        }
        return '\uffff';
    }

    @Override
    public boolean encode(ByteBuffer buffer, char c) {
        if (buffer.hasRemaining()) {
            buffer.put((byte)(c < 128 ? c : 32));
            return true;
        }
        return false;
    }

    @Override
    public int size(char c) {
        return 1;
    }
}

